<?php

namespace App\Console\Commands;

use App\Models\Document;
use App\Models\Dossier;
use App\Models\Notification;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class Task extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:task';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Relance';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $dossiers = Dossier::where('dossier_status_id', 2)->get();
        foreach ($dossiers as $dossier) {
            $document = Document::where('dossier_id', $dossier->id)->where('type_document_id', 4)->count();
            if ($document === 0) {
                $body = "Relance Devis Drr";
                Notification::create([
                    'user_id' => 5,
                    'dossier_id' => $dossier->id,
                    'body' => $body
                ]);
            }
        }
        return Command::SUCCESS;
    }
}
 
