<?php

namespace App\Http\Controllers;

use App\Models\Document;
use App\Models\Dossier;
use App\Models\NoteHonoraire;
use App\Models\Payment;
use App\Models\Rapport;
use App\Models\TypeDocument;
use Barryvdh\DomPDF\Facade\Pdf;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny', Payment::class);

        $payments = Payment::with('status', 'notehonoraire', 'notehonoraire.company', 'notehonoraire.typeexpertise')->paginate(10);
        $dossiers = Dossier::whereDoesntHave('payment')->get();
        return view('configuration.Payment.index', compact('payments', 'dossiers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $this->authorize('create', Payment::class);

        $dossier = Dossier::whereId($id)->first();
        $payment = Payment::where('dossier_id', $id)->first();
        if ($payment) {
            return redirect()->route('Payment.edit', $payment->id);
        }
        return view('configuration.Payment.create', compact('dossier'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Payment::class);

        $dossier = Dossier::whereId($request->dossier_id)->firstOrFail();
        $payment = Payment::where('dossier_id', $dossier->id)->count();
        if ($payment) {
            return redirect()->route('Payment.edit', $payment->id);
        }

        $note = NoteHonoraire::where('company_id', $dossier->company_id)->where('type_expertise_id', $dossier->type_expertise_id)->first();
        if (!$note) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Il faut ajouter une nouveau note honoraire avec assurance et type de dossier');
        }
        $ht = $request->frais_deplacement + $request->frais_sejour + $request->frais_divers + $note->montant;
        $tva = $ht / 20;
        $ttc = $ht - $tva;

        $payment = Payment::create([
            // 'ref' => $ref,
            'dossier_id' => $dossier->id,
            'note_honoraire_id' => $note->id,
            'note_honoraire_status_id' => 2,
            'frais_deplacement' => $request->frais_deplacement,
            'frais_sejour' => $request->frais_sejour,
            'frais_divers' => $request->frais_divers,
            'montant' => $ttc,
            'montant_restant' => $ttc
        ]);

        $payment->ref = $payment->id.'-'.date('y');
        $payment->update();

        $pdf = PDF::loadView('configuration.pdf.noteHonoraire', compact('dossier', 'note', 'payment', 'ttc', 'ht', 'tva'));
        $type = TypeDocument::whereId(12)->first();
        $filename = uniqid() . '.' . 'pdf';
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        Document::updateOrCreate(['dossier_id' => $dossier->id,'type_document_id' => $type->id],[
            'path' => $path,
        ]);

        return redirect()->route('Payment.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('view', Payment::class);

        $payment = Payment::whereId($id)->with('notehonoraire')->firstOrFail();
        $doc = Document::where('dossier_id', $payment->dossier_id)->where('type_document_id', 12)->latest()->first();
        return view('configuration.Payment.show', compact('doc'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', Payment::class);

        $payment = Payment::whereId($id)->with('notehonoraire')->firstOrFail();
        if ($payment->note_honoraire_status_id == 1) {
            return redirect()->route('Payment.show',$payment->id);
        }
        $doc = Document::where('dossier_id', $payment->dossier_id)->where('type_document_id', 12)->first();
        return view('configuration.Payment.edit', compact('payment', 'doc'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update', Payment::class);

        $payment = Payment::whereId($id)->with('notehonoraire')->firstOrFail();
        $dossier = Dossier::whereId($payment->dossier_id)->firstOrFail();
        $note = NoteHonoraire::where('company_id', $dossier->company_id)->where('type_expertise_id', $dossier->type_expertise_id)->first();
        $ht = $request->frais_deplacement + $request->frais_sejour + $request->frais_divers + $note->montant;
        $tva = $ht / 20;
        $ttc = $ht - $tva;
        $payment->frais_deplacement = $request->frais_deplacement;
        $payment->frais_sejour = $request->frais_sejour;
        $payment->frais_divers = $request->frais_divers;
        $payment->montant = $ttc;
        $payment->update();

        $doc = Document::where('dossier_id', $payment->dossier_id)->where('type_document_id', 12)->first();
        if ($doc) {
            $doc->delete();
        }
        // dd($ttc);
        $pdf = PDF::loadView('configuration.pdf.noteHonoraire', compact('dossier', 'note', 'payment', 'ttc', 'ht', 'tva'));
        $type = TypeDocument::whereId(12)->first();
        $filename = uniqid() . '.' . 'pdf';
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        Document::updateOrCreate(['dossier_id' => $dossier->id,'type_document_id' => $type->id],[
            'path' => $path,
        ]);

        return redirect()->route('Dossier.show', $dossier->id);
    }

    // public function status($id)
    // {
    //     $payment = Payment::whereId($id)->with('notehonoraire')->firstOrFail();
    //     $payment->notehonoraire_status_id = 1;
    //     $payment->update();
    //     $dossier = Dossier::whereId($payment->dossier_id)->firstOrFail();
    //     $note = NoteHonoraire::where('company_id',$dossier->company_id)->where('type_expertise_id',$dossier->type_expertise_id)->first();
    //     $doc = Document::where('dossier_id',$payment->dossier_id)->where('type_document_id',12)->first();
    //     if($doc){
    //         $doc->delete();
    //     }
    //     $ht = $payment->frais_deplacement + $payment->frais_sejour + $payment->frais_divers + $note->montant ;
    //     $tva = ($ht*20)/100;
    //     $ttc =$ht - $tva;
    //     $pdf = PDF::loadView('configuration.pdf.noteHonoraire', compact('dossier','note','payment','ttc','ht','tva'));        $type = TypeDocument::whereId(12)->first();
    //     $filename = uniqid(). '.' .'pdf';
    //     $path ='documents/'.$dossier->ref.'/'.$type->type.'/'.$filename;
    //     Storage::disk('s3')->put('documents/'.$dossier->ref.'/'.$type->type.'/'.$filename, $pdf->output());

    //     $document = Document::create([
    //         'path' => $path,
    //         'type_document_id' => $type->id,
    //         'dossier_id' => $dossier->id,
    //     ]);

    //     return redirect()->route('Dossier.show',$dossier->id);

    // }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payment $payment)
    {
        //
    }
}
