<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Demande extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'dossier_id',
        'motif',
        'user_id',
        'status_rendezvous_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->belongsTo(StatusRendezvous::class ,'status_rendezvous_id');
    }
    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }

}
