<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expert extends Model
{
    use HasFactory;
    protected $fillable =[
        'name',
        'tel',
        'adress',
        'email',
        'city_id'
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }


    public function contradictoire()
    {
        return $this->hasMany(Contradictoire::class);
    }

}
