<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NoteHonoraire extends Model
{
    use HasFactory;

    protected $fillable =[
        'company_id',
        'type_expertise_id',
        'montant'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function payment()
    {
        return $this->hasMany(Payment::class ,'notehonoraire_id');
    }

    public function typeexpertise()
    {
        return $this->belongsTo(TypeExpertise::class,'type_expertise_id');
    }

}
