<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TypeExpertise extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable =['type'];

    public function dossier()
    {
        return $this->hasMany(Dossier::class)->withTrashed();
    }

    public function notehonoraire()
    {
        return $this->hasMany(NoteHonoraire::class);
    }


    public function usercompany()
    {
        return $this->belongsToMany(Company::class, 'user_company_type')
            ->withPivot('user_id');
    }


    public function user()
    {
        return $this->belongsToMany(User::class,'user_typeexpertise');
    }

}
