<?php

namespace App\Providers;

use App\Models\Devis;
use App\Models\Document;
use App\Models\Dossier;
use App\Models\Facture;
use App\Models\Meeting;
use App\Observers\DevisObserver;
use App\Observers\DocumentObserver;
use App\Observers\DossierObserver;
use App\Observers\FactureObserver;
use App\Observers\MeetingObserver;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        Dossier::observe(DossierObserver::class);
        Meeting::observe(MeetingObserver::class);
        Devis::observe(DevisObserver::class);
        Facture::observe(FactureObserver::class);
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return bool
     */
    public function shouldDiscoverEvents()
    {
        return false;
    }
}
