
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h2 class="my-1 mx-1 text-dark" id="title">Dossiers</h2>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-1">
        <div id="pagination">

            <button class="btn btn-outline-success mb-2" onclick="exportToExcel()">Exporter Excel</button>
        </div>
        <div class="col-12">

            <div class="card">
                <div class="card-body">
                    <table class="table table-stripped" id="myTable">
                        <thead>
                            <tr>
                                <th scope="col">Reference Dossier</th>
                                <th scope="col">Compagnie</th>
                                <th scope="col">Assuré</th>
                                <th scope="col">Matricule</th>
                                <th>Numero Sinistre</th>
                                <th scope="col">Type De Dossier</th>
                                <th>Mode</th>
                                <th scope="col">Etape</th>
                                <th scope="col">Delai</th>
                                <th scope="col">Status</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($dossiers): ?>
                                <?php $__currentLoopData = $dossiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dossier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($dossier->update == 1): ?>
                                        <tr class="table-success">
                                        <?php else: ?>
                                        <tr>
                                    <?php endif; ?>

                                    <td>
                                        <?php echo e($dossier->ref ?? null); ?>

                                    </td>
                                    <td>
                                        <?php echo e($dossier->company->company ?? null); ?>

                                    </td>
                                    <td>
                                        <?php echo e($dossier->insured->name ?? null); ?>

                                    </td>
                                    <td>
                                        <?php echo e($dossier->matricule ?? $dossier->new_matricule); ?>

                                    </td>
                                    <td>
                                        <?php echo e($dossier->numero_sinistre ?? null); ?>

                                    </td>
                                    <td>
                                        <span class="badge bg-success">
                                            <?php echo e($dossier->typeexpertise->type ?? null); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">
                                            <?php echo e($dossier->mode->mode ?? null); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-dark">
                                            <?php echo e($dossier->currentStep->step ?? null); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($dossier->timeleft > 0): ?>
                                            <span class="badge bg-warning">
                                                <?php echo e($dossier->timeleft ?? null); ?>H
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">
                                                <?php echo e($dossier->timeleft ?? null); ?>H
                                            </span>
                                        <?php endif; ?>

                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($dossier->status->color); ?>">
                                            <?php echo e($dossier->status->status ?? null); ?>

                                        </span>
                                    </td>

                                    <td>
                                        <a class="rounded-pill text-primary"
                                            href="<?php echo e(route('Dossier.show', $dossier->id)); ?>">
                                            <i class="uil uil-eye fs-4"></i>
                                        </a>
                                    </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <input type="hidden" id="role" value="<?php echo e(Auth::user()->role_id); ?>">
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        function loadData(url, title) {
            var dataTable = $('#myTable').DataTable();
            dataTable.clear();

            $.ajax({
                url: url,
                type: 'get',
                success: function(response) {
                    // console.log(response);
                    var html = '';
                    $.each(response, function(k, v) {

                        if (v.update == 1) {
                            html += "<tr class='table-success'>";
                        } else {
                            html += "<tr>";
                        }
                        html += "<td>" + v.ref + "</td>";
                        html += "<td>" + (v.company_id != null ? v.company.company : ".") + "</td>";
                        html += "<td>" + (v.insured && v.insured.name ? v.insured.name :
                            ".") + "</td>";
                        html += "<td>" + (v.matricule != null ? v.matricule : v
                            .new_matricule) + "</td>";
                        html += "<td>" + (v.numero_sinistre != null ? v.numero_sinistre : ".") + "</td>";
                        html += "<td> <span class='badge bg-success' >" + (v
                                .typeexpertise && v.typeexpertise.type ? v.typeexpertise
                                .type : ".") +
                            "</span> </td>";
                        html += "<td> <span class='badge bg-info' >" + (v
                                .mode && v.mode.mode ? v.mode
                                .mode : ".") +
                            "</span> </td>";
                        html += "<td> <span class='badge bg-dark' >" + v.current_step.step +
                            "</span> </td>";
                        if (v.timeleft > 0) {
                            html += "<td> <span class='badge bg-warning' >" + v.timeleft +
                                "H</span> </td>";
                        } else {
                            html += "<td> <span class='badge bg-danger' >" + v.timeleft +
                                "H</span> </td>";
                        }
                        html += "<td><span class='badge bg-" + v.status.color + "' >" + v
                            .status
                            .status + "</span> </td>";
                        html += "<td > <a href='Dossier/" + v.id +
                            "' class='text-info rounded-pill' > <i class='uil uil-eye fs-4'> </i> </a> </td>";
                        html += "</tr>";

                    });

                    dataTable.rows.add($(html)).draw(false);
                    $("#title").text(title);
                },
                error: function(res) {
                    console.log(res);
                }
            });

        }
        let roleId = document.getElementById('role').value;
        // console.log(roleId);


        let col1 = document.getElementById('collapse1');
        if (col1) {
            col1.addEventListener("click", () => {
                loadData('/Expertiser', 'Dossier A Expertiser');
            });
        }

        let col92 = document.getElementById('collapse92');
        if (col92) {
            col92.addEventListener("click", () => {
                loadData('/Expertise/encours', 'Dossier En Expertiser');
            });
        }

        let col95 = document.getElementById('collapse95');
        if (col95) {
            col95.addEventListener("click", () => {
                loadData('/Instance/Rapport', 'Instance Rapport');
            });
        }

        let col2 = document.getElementById('collapse2');
        if (col2) {
            col2.addEventListener("click", () => {
                loadData('/Devis/Carence', 'Besoin Devis');
            });
        }

        let col3 = document.getElementById('collapse3');
        if (col3) {
            col3.addEventListener("click", () => {
                loadData('/Facture/Carence', 'Besoin Facture');
            });
        }

        let col4 = document.getElementById('collapse4');
        if (col4) {
            col4.addEventListener("click", () => {
                loadData('/Carence/Rapport', 'Besoin Rapport');
            });
        }

        let col13 = document.getElementById('collapse13');
        if (col13) {
            col13.addEventListener("click", () => {
                loadData('/Devis/Envoyer', 'Devis A Envoyer');
            });
        }

        let col14 = document.getElementById('collapse14');
        if (col14) {
            col14.addEventListener("click", () => {
                loadData('/Facture/Envoyer', 'Facture A Envoyer');
            });
        }

        let col15 = document.getElementById('collapse15');
        if (col15) {
            col15.addEventListener("click", () => {
                loadData('/Envoyer/Rapport', 'Rapport A Envoyer');
            });
        }

        let col16 = document.getElementById('collapse16');
        if (col16) {
            col16.addEventListener("click", () => {
                loadData('/Devis/Deuxieme', '2éme Devis');
            });
        }

        let col17 = document.getElementById('collapse17');
        if (col17) {
            col17.addEventListener("click", () => {
                loadData('/Facture/Deuxieme', '2éme Facture');
            });
        }

        let col05 = document.getElementById('collapse05');
        if (col05) {
            col05.addEventListener("click", () => {
                loadData('/Deuxieme/Rapport', 'Rapport Refuser ');
            });
        }

        let col90 = document.getElementById('collapse90');
        if (col90) {
            col90.addEventListener("click", () => {
                loadData('/Facture/Trait', 'Facture en Attente Accord');
            });
        }

        let col91 = document.getElementById('collapse91');
        if (col91) {
            col91.addEventListener("click", () => {
                loadData('/Devis/Trait', 'Devis en Attente Accord');
            });
        }

        let col72 = document.getElementById('collapse72');
        if (col72) {
            col72.addEventListener("click", () => {
                loadData('/Base', 'Attente Doc de Base');
            });
        }

        let col50 = document.getElementById('collapse50');
        if (col50) {
            col50.addEventListener("click", () => {
                loadData('/Signer/Document', 'Document A Signer');
            });
        }

        let col80 = document.getElementById('collapse80');
        if (col80) {
            col80.addEventListener("click", () => {
                loadData('/Devis/Photo', 'Devis Attente Photo Avant');
            });
        }

        let col81 = document.getElementById('collapse81');
        if (col81) {
            col81.addEventListener("click", () => {
                loadData('/Facture/Photo', 'Facture Attente Photo Aprés');
            });
        }

        let col96 = document.getElementById('collapse96');
        if (col96) {
            col96.addEventListener("click", () => {
                loadData('/Expertise/Apres', 'Attente Photo Aprés');
            });
        }

        let col5 = document.getElementById('collapse5');
        if (col5) {
            col5.addEventListener("click", () => {
                loadData('/Devis/Retraiter', 'Devis A Retraiter');
            });
        }

        let col6 = document.getElementById('collapse6');
        if (col6) {
            col6.addEventListener("click", () => {
                loadData('/Facture/Retraiter', 'Facture A Retraiter');
            });
        }

        let col77 = document.getElementById('collapse77');
        if (col77) {
            col77.addEventListener("click", () => {
                loadData('/Devis/Traitement', 'Devis A Traiter');
            });
        }

        let col9 = document.getElementById('collapse9');
        if (col9) {
            col9.addEventListener("click", () => {
                loadData('/Facture/Traitement', 'Facture A Traiter');
            });
        }

        let col93 = document.getElementById('collapse93');
        if (col93) {
            col93.addEventListener("click", () => {
                loadData('/Devis/Controler', 'Devis A Controler');
            });
        }

        let col8 = document.getElementById('collapse8');
        if (col8) {
            col8.addEventListener("click", () => {
                loadData('/Signer/Rapport', 'Rapport A Signer');
            });
        }

        let col10 = document.getElementById('collapse10');
        if (col10) {
            col10.addEventListener("click", () => {
                loadData('/Devis/Avis', 'Demande Avis Devis');
            });
        }

        let col11 = document.getElementById('collapse11');
        if (col11) {
            col11.addEventListener("click", () => {
                loadData('/Facture/Avis', 'Demande Avis Facture');
            });
        }

        let col20 = document.getElementById('collapse20');
        if (col20) {
            col20.addEventListener("click", () => {
                loadData('/Douteux', 'Sinistre Douteux');
            });
        }

        let col21 = document.getElementById('collapse21');
        if (col21) {
            col21.addEventListener("click", () => {
                loadData('/Tribunale', 'Dossier Tribunale');
            });
        }

        let col85 = document.getElementById('collapse85');
        if (col85) {
            col85.addEventListener("click", () => {
                loadData('/Facturation', 'Dossier a Facturé');
            });
        }
        let col71 = document.getElementById('collapse71')
        if (col71) {
            col71.addEventListener("click", () => {
                loadData('/Rapide', 'Dossier Rapide');
            });
        }
        let col88 = document.getElementById('collapse88');
        if (col88) {
            col88.addEventListener("click", () => {
                loadData('/Signé/Document', 'Document Signé');
            });
        }


        // if (roleId != 3) {

        //     let col92 = document.getElementById('collapse92');
        //     col92.addEventListener("click", (e) => {
        //         loadData('/Expertise/encours', 'Dossier En Expertiser');
        //     });

        //     let col71 = document.getElementById('collapse71')
        //     col71.addEventListener("click", () => {
        //         loadData('/Rapide', 'Dossier Rapide');
        //     });
        // }
        // if (roleId == 7) {

        //     let col92 = document.getElementById('collapse92');
        //     col92.addEventListener("click", (e) => {
        //         loadData('/Expertise/encours', 'Dossier En Expertiser');
        //     });
        //     let col50 = document.getElementById('collapse50')
        //     col50.addEventListener("click", () => {
        //         loadData('/Signer/Document', 'Document A Signer');
        //     });
        //     let col93 = document.getElementById('collapse93')
        //     col93.addEventListener("click", () => {
        //         loadData('/Devis/Controler', 'Devis A Controler');
        //     });

        //     let col8 = document.getElementById('collapse8')
        //     col8.addEventListener("click", () => {
        //         loadData('/Signer/Rapport', 'Rapport A Signer');
        //     });
        // }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.test', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\engi.ameamaroc.ma\resources\views/dashboards/front.blade.php ENDPATH**/ ?>