@extends('layouts.config_dashboard.app')
@section('style')
@endsection
@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">Historique</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
                            <form action="{{ route('notification.index') }}" method="get">
                                <div class="mb-3 col-4">
                                    <label for="example-date" class="form-label ">Date</label>
                                    <input class="form-control @error('date') is-invalid @enderror" id="date"
                                        type="date" name="date">
                                    @error('date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-4">
                                    <label for="example-date" class="form-label ">Ref Dossier</label>
                                    <input class="form-control @error('ref') is-invalid @enderror" id="ref"
                                        type="text" name="ref">
                                    @error('ref')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 d-flex justify-content-center">
                                    <button type="submit" id="search" class="btn btn-sm btn-success">
                                        <span class="mdi mdi-magnify search-icon"></span></button>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Dossier Ref</th>
                                        <th>Actionneur</th>
                                        <th>Action</th>
                                        <th>date creation</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($notifications as $notification)
                                        <tr>
                                            <td>{{ $notification->id }}</td>
                                            <td>{{ $notification->dossier->ref }}</td>
                                            <td> <span class="fs-5 badge bg-primary">{{ $notification->user->name }}</span>
                                            </td>
                                            <td>{{ $notification->body }}</td>
                                            <td>{{ $notification->created_at->format('Y:m:d') }}</td>

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                            @if ($notifications->hasPages())
                            <div style="float:right" class="pagination-wrapper">
                                {{ $notifications->links() }}
                            </div>
                        @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

