@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        @can('create', App\Models\NoteHonoraire::class)
                            <div class="row mb-3">
                                <div class="d-flex ">
                                    <div class="col-md-6">
                                        <a class="btn btn-primary" href="{{ route('NoteHonoraire.create') }}">Creer </a>
                                    </div>
                                </div>
                            </div>
                        @endcan
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Company</th>
                                        <th>Type Dossier</th>
                                        <th>Montant</th>
                                        <th>Modifier</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($notes as $note)
                                        <tr>
                                            <td>{{ $note->id }}</td>
                                            <td>{{ $note->company->company }}</td>
                                            <td>{{ $note->typeexpertise->type }}</td>
                                            <td>
                                                <span class="fs-5 badge bg-info">{{ $note->montant }} MAD</span>
                                            </td>


                                            @can('update', App\Models\NoteHonoraire::class)
                                                <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                        href="{{ route('NoteHonoraire.edit', [$note->id]) }}">
                                                        <i class="uil uil-pen fs-5"></i>
                                                    </a>
                                                </td>
                                            @endcan

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
