@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des Demandes</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 mb-2">
                <div class="page-title-box"> 
                    <div class="page-title-left ">
                        <a href="{{ route('Dossier.show', $id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Utilisateur</th>
                                        <th>Motif</th>
                                        <th>Status</th>
                                        @if (Auth::user()->role_id == 4)
                                        <th>Dossier</th>
                                        <th>Detail</th>
                                        @endif

                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($demandes as $demande)
                                        <tr>
                                            <td>{{ $demande->id }}</td>
                                            <td>{{ $demande->user->name ?? null }}</td>
                                            <td>{{ $demande->motif ?? null }}</td>
                                            <td> <span class="badge bg-{{ $demande->status->color }}">{{ $demande->status->status ?? null }}</span></td>

                                            @if (Auth::user()->role_id == 4)
                                            <td>
                                                <a class="btn btn-sm btn-info rounded-pill"
                                                    href="{{ route('Dossier.show', [$demande->dossier_id]) }}"><i
                                                class="uil uil-eye fs-5"></i></a>
                                            </td>
                                            <td>
                                                <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Demande.edit', [$demande->id]) }}"><i
                                                class="uil uil-eye fs-5"></i></a>
                                            </td>
                                            @endif

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
