@extends('layouts.dashboard.app')
@section('style')
@endsection
@section('content')
    <div class="container mt-1">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-info mb-3">Dossier {{ $dossier->ref }}
                            @if ($dossier->sinistre_douteux)
                                <span class="badge bg-success">Sinistre Douteux</span>
                            @endif
                        </h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Reference</th>
                                        <th>Matricule</th>
                                        <th>Compagnie</th>
                                        <th>Garantie</th>
                                        <th>Date Sinistre</th>
                                        <th>Date Reception</th>
                                        <th>Type de Dossier</th>
                                        <th>Mode</th>
                                        <th>Vehicule</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <input type="hidden" value="{{ $dossier->id }}" id="id">
                                        <td class="text-dark">{{ $dossier->ref ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->matricule ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->company->company ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->guarantee->guarantee ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_sinistre ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_reception ?? null }}</td>
                                        <td> <span
                                                class="badge badge-primary-lighten">{{ $dossier->typeexpertise->type ?? null }}</span>
                                        </td>
                                        <td> <span
                                                class="badge badge-success-lighten">{{ $dossier->mode->mode ?? null }}</span>
                                        </td>
                                        <td>{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-3">Ajouter Facture : </h4>
                <div class="row mb-5" style="margin-left: 35px;">
                    <form id="myForm" method="POST" enctype="multipart/form-data" action="{{ route('Dossier.cloturer') }}">
                        @csrf
                        <input type="hidden" name="dossier_id" value="{{ $dossier->id }}" required>
                        <div class="form-group mb-1">
                            <label for="facture">Telecharger  :</label>

                            <input name="files[]" class="form-control @error('files') is-invalid @enderror" required
                                onchange="onUpload(this.files)" multiple type="file" accept="image/*,.pdf" />
                            <input type="hidden" name="pdfs" id="pdf" value="">
                            @error('facture')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="row mt-3">
                            <div class="col-6">
                                <button id="btn" class="btn btn-success" type="submit"> Cloturer Dossier</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.2.228/pdf.min.js"></script>
    <script>
        // $(document).ready(function() {
        //     $('input[type="file"]').imageuploadify();
        // });
        var table = [];

        function onUpload(files) {
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                if (file.type === 'application/pdf') {
                    const reader = new FileReader();
                    reader.onload = e => {
                        const data = atob(e.target.result.replace(/.*base64,/, ''));
                        console.log(data);
                        renderPDF(data);
                    }
                    reader.readAsDataURL(file);
                }
            }
        }

        async function renderPDF(data) {
            const pdf = await pdfjsLib.getDocument({
                data
            }).promise;
            for (let i = 1; i <= pdf.numPages; i++) {
                const image = document.createElement('img');
                const page = await pdf.getPage(i);
                const viewport = page.getViewport({
                    scale: 2
                });
                const canvas = document.createElement('canvas');
                const canvasContext = canvas.getContext('2d');
                canvas.height = viewport.height;
                canvas.width = viewport.width;
                await page.render({
                    canvasContext,
                    viewport
                }).promise;
                const dataUrl = canvas.toDataURL('image/png');
                image.src = dataUrl;
                image.classList.add('img');
                table.push(dataUrl);
            }
            const btn = document.getElementById('btn');
            btn.addEventListener('click', e => {
                e.preventDefault();
                const input = document.getElementById('pdf');
                input.value = JSON.stringify(table);
                document.getElementById('myForm').submit();
            });
        }
    </script>
@endsection
