@extends('layouts.dashboard.app')
@section('style')
@endsection
@section('content')
    <!-- tasks panel -->
    <div class="row">
        <div class="page-title-left ">
            <a href="{{ route('Dossier.show', $dossier->id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
        </div>
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title text-info mb-3">Dossier {{ $dossier->ref }} @if ($dossier->sinistre_douteux)
                            <span class="badge bg-success">Sinistre Douteux</span>
                        @endif
                    </h4>
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Reference</th>
                                    <th>Matricule</th>
                                    <th>Compagnie</th>
                                    <th>Garantie</th>
                                    <th>Date Sinistre</th>
                                    <th>Date Reception</th>
                                    <th>Type de Dossier</th>
                                    <th>Mode</th>
                                    <th>Vehicule</th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <input type="hidden" value="{{ $dossier->id }}" id="id">
                                    <td class="text-dark">{{ $dossier->ref ?? null }}</td>
                                    <td class="text-dark">{{ $dossier->matricule ?? null }}</td>
                                    <td class="text-dark">{{ $dossier->company->company ?? null }}</td>
                                    <td class="text-dark">{{ $dossier->guarantee->guarantee ?? null }}</td>
                                    <td class="text-dark">{{ $dossier->date_sinistre ?? null }}</td>
                                    <td class="text-dark">{{ $dossier->date_reception ?? null }}</td>
                                    <td> <span
                                            class="badge badge-primary-lighten">{{ $dossier->typeexpertise->type ?? null }}</span>
                                    </td>
                                    <td> <span class="badge badge-success-lighten">{{ $dossier->mode->mode ?? null }}</span>
                                    </td>
                                    <td>{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- end table-responsive -->
                </div>
            </div>
        </div> <!-- end col -->


    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="POST" action="{{ route('Dossier.affecter') }}">
                        @csrf
                        <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                        <div class="col-md-6">
                            <label for="type" class="form-label">Type des photos</label>
                            <select name="user_id" id="user_id"
                                class="form-select @error('user_id') is-invalid @enderror ">
                                @foreach ($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name ?? null }}</option>
                                @endforeach

                            </select>
                            @error('user_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <button style="float: right" class="btn btn-success mt-3" type="submit"> Affecter</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @foreach ($dossier->dossierstatus as $status)
                    <span class="badge bg-{{ $status->color ?? null}}">{{ $status->status ?? null}}</span> On <span>{{ $status->pivot->created_at ?? null}}</span>
                    <hr>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="mt-2">

        @foreach ($historique as $hist)
        <div class="collapse show" id="todayTasks">
            <div class="card mb-0">
                <div class="card-body">
                        <!-- task -->
                        <div class="row justify-content-sm-between">
                            <div class="col-sm-6 mb-2 mb-sm-0">
                                <div class="form-check">
                                    <label class="form-check-label" for="task1">
                                        {{ $hist->name }}
                                    </label>
                                </div> <!-- end checkbox -->
                            </div> <!-- end col -->
                            <div class="col-sm-6">
                                <div class="d-flex justify-content-between">
                                    <div id="tooltip-container">

                                        <h6><span class="badge bg-success">{{ $hist->step }}</span></h6>

                                    </div>
                                    <div>
                                        <ul class="list-inline font-13 text-end">
                                            <li class="list-inline-item">
                                                <i class='uil uil-schedule font-16 me-1'></i> {{ $hist->created_at }}
                                            </li>
                                            {{-- @if ()
                                            <li class="list-inline-item ms-2">
                                                <span class="badge badge-danger-lighten p-1">High</span>
                                            </li>
                                            @endif --}}
                                        </ul>
                                    </div>
                                </div> <!-- end .d-flex-->
                            </div> <!-- end col -->
                        </div>

                    <!-- end task -->
                </div> <!-- end card-body-->
            </div> <!-- end card -->
        </div> <!-- end .collapse-->
    @endforeach

    </div> <!-- end .mt-2-->

@endsection
