@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title text-dark">Dossier <span class="badge bg-success">En cours</span></h4>
                </div>
                <div class="page-title-box">
                    <form action="{{ route('Dossier.export') }}" method="post">
                        @csrf
                        <button style="float: right" class="btn btn-success"> Export Excel</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="table-responsive mt-1">
            <table class="table table-stripped" id="">
                <thead class="table-light">
                    <tr>
                        <th style="width: 20px;">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="customCheck1">
                                <label class="form-check-label" for="customCheck1">&nbsp;</label>
                            </div>
                        </th>
                        <th>Reference Dossier</th>
                        <th>Compagnie</th>
                        <th>Assuré</th>
                        <th>Matricule</th>
                        <th>Date de Sinistre</th>
                        <th>Nature De Dossier</th>
                        <th>Status</th>
                        <th style="width: 125px;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($dossiers as $dossier)
                        <tr>
                            <td>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="customCheck2">
                                    <label class="form-check-label" for="customCheck2">&nbsp;</label>
                                </div>
                            </td>
                            <td style="color: black; font-weight:bold">
                                {{ $dossier->ref  ?? null}}
                            </td>
                            <td>
                                {{ $dossier->company->company ?? null }}
                            </td>
                            <td>
                                <h5>
                                    {{ $dossier->insured->name  ?? null}}
                                </h5>
                            </td>
                            <td>
                                {{ $dossier->matricule  ?? null}}
                            </td>
                            <td>
                                {{ $dossier->date_sinistre ?? null }}
                            </td>
                            <td>
                                <span class="badge bg-info fs-5">{{ $dossier->typeexpertise->type ?? null }}</span>
                            </td>
                            <td>
                                <span class="badge bg-primary">
                                    {{ $dossier->currentStep->step ?? null}}
                                </span>
                            </td>

                            <td>
                                @can('view', $dossier)
                                <a href="{{ route('Dossier.show', $dossier->id) }}" class="action-icon text-dark">
                                     <i class="mdi mdi-eye"></i>
                                </a>
                                @endcan
                                @can('update', $dossier)
                                <a href="{{ route('Dossier.edit', $dossier->id) }}" class="action-icon text-primary"> <i
                                    class="mdi mdi-square-edit-outline"></i></a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                {!! $dossiers->links() !!}
            </div>
        </div>
        <br>
        {{-- <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title text-dark">Dossier <span class="badge bg-danger">Anomalie</span></h4>
                </div>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-stripped" id="myTable">
                <thead class="table-light">
                    <tr>
                        <th style="width: 20px;">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="customCheck1">
                                <label class="form-check-label" for="customCheck1">&nbsp;</label>
                            </div>
                        </th>
                        <th>Reference Dossier</th>
                        <th>Compagnie</th>
                        <th>Assuré</th>
                        <th>Matricule</th>
                        <th>Date de Sinistre</th>
                        <th>Nature De Dossier</th>
                        <th style="width: 125px;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($dossiersAnomalie as $dossier)
                        <tr>
                            <td>
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="customCheck2">
                                    <label class="form-check-label" for="customCheck2">&nbsp;</label>
                                </div>
                            </td>
                            <td style="color: black; font-weight:bold">
                                {{ $dossier->ref }}
                            </td>
                            <td>
                                {{ $dossier->company->company ?? null }}
                            </td>

                            <td>
                                <h5>
                                    {{ $dossier->insured->name  ?? null}}
                                </h5>
                            </td>
                            <td>
                                {{ $dossier->matricule  ?? null}}
                            </td>
                            <td>
                                {{ $dossier->date_sinistre ?? null }}
                            </td>
                            <td>
                                <span class="badge bg-info fs-5">{{ $dossier->typeexpertise->type ?? '' }}</span>
                            </td>

                            <td>
                                @can('view', $dossier)
                                <a href="{{ route('Dossier.show', $dossier->id) }}" class="action-icon text-dark"> <i
                                        class="mdi mdi-eye"></i></a>
                                @endcan
                                @can('update', $dossier)
                                <a href="{{ route('Dossier.edit', $dossier->id) }}" class="action-icon text-primary">
                                    <i class="mdi mdi-square-edit-outline"></i>
                                </a>
                                @endcan

                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                {!! $dossiersAnomalie->links() !!}
            </div>
        </div> --}}
    </div> <!-- end card-body-->

@endsection
