@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                @can('viewAny', App\Models\Email::class)
                                    <div class="col-md-6">
                                        <a style="float: left" href="{{ route('Email.create') }}"
                                            class="btn btn-success rounded-pill"> Créer</a>

                                    </div>
                                @endcan
                                {{-- <div class="col-md-6">
                                    <a style="float: right" href="{{ route('TypeDossier.deleted') }}"
                                        class="btn btn-warning rounded-pill"> Restaurer</a>
                                </div> --}}
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Etape</th>
                                        <th>Email</th>
                                        <th>Delai</th>
                                        <th>Afficher</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($emails as $email)
                                        <tr>
                                            <td>{{ $email->id }}</td>
                                            <td>
                                                <span class="badge bg-info">{{ $email->step->step ?? null }}</span>
                                            </td>
                                            <td>{{ $email->content ?? null }}</td>
                                            <td>{{ $email->delai ?? null }}</td>

                                            @can('create', App\Models\Email::class)
                                            <td> <a class="btn btn-sm btn-info rounded-pill"
                                                    href="{{ route('Email.show', [$email->id]) }}">
                                                    <i class="uil uil-eye fs-5"></i>
                                                </a>
                                            </td>
                                            @endcan

                                            @can('update', App\Models\Email::class)
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Email.edit', [$email->id]) }}">
                                                    <i class="uil uil-pen fs-5"></i>
                                                </a>
                                            </td>
                                            @endcan

                                            <td>
                                                @can('delete', App\Models\Email::class)
                                                <form action="{{ route('Email.destroy', [$email->id]) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                        <i class="uil uil-trash fs-5"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
