<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/imageuploadify.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- File Upload -->
    <div class="row">
        <div class="page-title-box">
            <div class="page-title-left mb-">
                <a href="<?php echo e(route('Dossier.show', $dossier->id)); ?>" class="mt-2 btn btn-outline-dark">Dossier</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <form action="<?php echo e(route('Document.store')); ?>" id="myForm" method="post" class=" mt-2 " enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="dossier" value="<?php echo e($id); ?>">
            <div class="row mt-2">
                <div class="mb-3 col-md-4">
                    <label for="type" class="form-label">Type de Document :</label>
                    <select name="type" id="type" class="form-control <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value="">Selectionner Type de Document</option>
                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id); ?>"><?php echo e($type->type); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                </div>

                <input name="files[]" class="<?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" onchange="onUpload(this.files)"
                    type="file" accept="image/*,.pdf" multiple />
                <input type="hidden" name="pdfs" id="pdf" value="">
                <div class="col-6 mt-2">
                    <?php if($errors->any()): ?>
                        <?php echo implode('', $errors->all('<div style="color: red;margin-top:3px;">:message</div>')); ?>

                    <?php endif; ?>
                </div>

                <div class="row">
                    <button type="submit" id="btn" class="btn btn-info mt-3">Upload</button>
                </div>

        </form>
    </div>
    <!-- Preview -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('js/imageuploadify.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.2.228/pdf.min.js"></script>
    <script>
        $(document).ready(function() {
            $('input[type="file"]').imageuploadify();
        });
        var table= [];
        function onUpload(files) {
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                if (file.type === 'application/pdf') {
                    const reader = new FileReader();
                    reader.onload = e => {
                        const data = atob(e.target.result.replace(/.*base64,/, ''));
                        renderPDF(data);
                    }
                    reader.readAsDataURL(file);
                }
            }
        }

        async function renderPDF(data) {
            const pdf = await pdfjsLib.getDocument({
                data
            }).promise;
            for (let i = 1; i <= pdf.numPages; i++) {
                const image = document.createElement('img');
                const page = await pdf.getPage(i);
                const viewport = page.getViewport({
                    scale: 2
                });
                const canvas = document.createElement('canvas');
                const canvasContext = canvas.getContext('2d');
                canvas.height = viewport.height;
                canvas.width = viewport.width;
                await page.render({
                    canvasContext,
                    viewport
                }).promise;
                const dataUrl = canvas.toDataURL('image/png');
                image.src = dataUrl;
                image.classList.add('img');
                table.push(dataUrl);
            }
            const btn = document.getElementById('btn');
            btn.addEventListener('click', e => {
                e.preventDefault();
                const input = document.getElementById('pdf');
                input.value = JSON.stringify(table);
                document.getElementById('myForm').submit();
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amea/public_html/app.ameaengi.com/resources/views/document/create.blade.php ENDPATH**/ ?>