<?php

namespace App\Http\Controllers;

use App\Models\TypeVehicule;
use Illuminate\Http\Request;

use function GuzzleHttp\Promise\all;

class TypeVehiculeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny', App\Models\TypeVehicule::class);

        $types = TypeVehicule::all();
        return view('configuration.Types.vehicules.index', compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', App\Models\TypeVehicule::class);

        return view('configuration.Types.vehicules.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', App\Models\TypeVehicule::class);

        $request->validate([
            'type' => 'required|unique:type_vehicules,type'
        ]);
        TypeVehicule::create([
            'type' => $request->type
        ]);
        return redirect()->route('TypeVehicule.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', App\Models\TypeVehicule::class);

        $type = TypeVehicule::whereId($id)->firstOrFail();
        return view('configuration.Types.vehicules.edit', compact('type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update', App\Models\TypeVehicule::class);

        $request->validate([
            'type' => 'required|unique:type_vehicules,type,'.$id
        ]);

        $type = TypeVehicule::whereId($id)->firstOrFail();
        $type->type = $request->type;
        $type->update();
        return redirect()->route('TypeVehicule.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


}
