<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Document extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['path', 'dossier_id', 'type_document_id','signer','edited','rejected','facture_mo'];


    public function typedocument()
    {
        return $this->belongsTo(TypeDocument::class,'type_document_id');
    }

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }

    public function statusdocument()
    {
        return $this->belongsTo(StatusDocument::class);
    }

    public function devis()
    {
        return $this->belongsToMany(Devis::class,'document_devis')->withTimestamps();
    }

    public function facture()
    {
        return $this->belongsToMany(Facture::class,'document_facture')->withTimestamps();
    }

    public function rapport()
    {
        return $this->hasOne(Rapport::class);
    }
    public function rapports()
    {
        return $this->belongsToMany(Rapport::class,'rapport_document')->withPivot('observation')->withTimestamps();
    }

    public function transaction()
    {
        return $this->belongsToMany(Transaction::class,'document_transaction')->withTimestamps();
    }

}
