<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permission extends Model
{
    use HasFactory ;


    protected $fillable =['permission'];
    public $timestamps = false;

    public function user(){

        return $this->belongsToMany(User::class , 'user_permission');
    }

    public function role(){

        return $this->belongsToMany(Role::class , 'role_permission');
    }

    public static function generateFor($table_name , $key)
    {
        self::firstOrCreate(['permission' => 'naviguer_'.$table_name, 'key'=>$key]);
        self::firstOrCreate(['permission' => 'afficher_'.$table_name, 'key'=>$key]);
        self::firstOrCreate(['permission' => 'modifier_'.$table_name, 'key'=>$key]);
        self::firstOrCreate(['permission' => 'ajouter_'.$table_name, 'key'=>$key]);
    }

}
