<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Step extends Model
{
    use HasFactory;

    protected $fillable = ['step'];


    public function dossier()
    {
        return $this->belongsToMany(Dossier::class,'step_dossier')->withPivot('user_id')->withTimestamps();
    }


    public function user()
    {
        return $this->belongsToMany(User::class,'step_dossier')->withTimestamps();
    }


    public function company()
    {
        return $this->belongsToMany(Company::class,'company_step')->withPivot('time')->withTimestamps();
    }

    public function onecompany()
    {
        return $this->belongsTo(Company::class)->withTimestamps();
    }

    public function sms()
    {
        return $this->hasOne(Sms::class);
    }

    public function Currentdossier()
    {
        return $this->hasOne(Dossier::class);
    }

    public function email()
    {
        return $this->hasMany(Email::class);
    }

}
