<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Devis;
use App\Models\Dossier;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Access\HandlesAuthorization;

class DevisPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('naviguer_devis') || $user->hasRolePermission('naviguer_devis') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Devis  $devis
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        if( $user->role_id === 4  ||  $user->hasPermission('afficher_devis') || $user->hasRolePermission('afficher_devis')){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->hasPermission('ajouter_devis') || $user->hasRolePermission('ajouter_devis') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Devis  $devis
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {

        if( $user->role_id === 4 || $user->hasPermission('modifier_devis') || $user->hasRolePermission('modifier_devis') ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Devis  $devis
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if( $user->role_id === 4 ){
            return true;
        }
    }

    public function chiffrage(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('chiffrage_devis') || $user->hasRolePermission('chiffrage_devis') ){
            return true;
        }
    }

    public function controler(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('controler_devis') || $user->hasRolePermission('controler_devis') ){
            return true;
        }
    }
    public function modifieraccord(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('modifier_accord_devis') || $user->hasRolePermission('modifier_accord_devis') ){
            return true;
        }
    }
    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Devis  $devis
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Devis $devis)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Devis  $devis
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Devis $devis)
    {
        //
    }
}
