<?php

namespace App\Policies;

use App\Models\Dossier;
use App\Models\Step;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Auth;

class DossierPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);

        if ($user->role_id === 4) {
            return true;
        }
        if ($user->hasPermission('naviguer_dossiers') || $user->hasRolePermission('naviguer_dossiers')) {
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, Dossier $dossier)
    {
        $user = User::whereId(Auth::user()->id)->first();

        if ($user->role_id == 4) {
            return true;
        }


        if ($user->hasPermission('afficher_dossiers') || $user->hasRolePermission('afficher_dossiers')) {
            if($dossier->dossier_status_id==3){
                return true;
            }
            if ($user->role_id == 3) {
                return true;
            }
            // $count = Dossier::whereId($dossier->id)->whereHas('step', function ($query) use ($user) {
            //     $query->where('user_id', $user->id);
            // })->with('step')->count();
            // if ($count > 0) {
            //     return true;
            // }
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if ($user->hasPermission('ajouter_dossiers') || $user->hasRolePermission('ajouter_dossiers') || $user->role_id === 4) {
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, Dossier $dossier)
    {
        $user = User::whereId(Auth::user()->id)->first();
        if ($user->role_id === 4) {
            return true;
        }
        $dossier = Dossier::whereId($dossier->id)->first();
        if ($user->hasPermission('modifier_dossiers') || $user->hasRolePermission('modifier_dossiers') &&  $dossier->update == 0) {
            $user = User::whereId(Auth::user()->id)->wherehas('typecompany', function ($query) use ($dossier) {
                $query->where('company_id', $dossier->company_id);
            })->wherehas('typec', function ($query) use($dossier) {
                $query->where('type_expertise_id', $dossier->type_expertise_id);
            })->exists();
            if ($user) {
                return true;
            }
        }
    }


    public function open(User $user)
    {
        if ($user->hasPermission('Reouvrir_dossiers') || $user->hasRolePermission('Reouvrir_dossiers') || $user->role_id == 4) {
            return true;
        }
    }


    public function annuler(User $user)
    {
        if ($user->role_id == 4 || $user->hasPermission('annuler_dossiers') || $user->hasRolePermission('annuler_dossiers') ) {
            return true;
        }
    }

    public function cloturer(User $user)
    {
        if ($user->role_id == 4 || $user->hasPermission('cloturer_dossiers') || $user->hasRolePermission('cloturer_dossiers') ) {
            return true;
        }
    }

    public function historique(User $user)
    {
        if ($user->hasPermission('Historique_Dossier') || $user->hasRolePermission('Historique_Dossier') || $user->role_id == 4) {
            return true;
        }
    }

    public function lien(User $user)
    {
        if ($user->hasPermission('Lien_Externe') || $user->hasRolePermission('Lien_Externe') || $user->role_id == 4) {
            return true;
        }
    }



    public function douteux(User $user)
    {
        if ($user->hasPermission('sinistre_douteux') || $user->hasRolePermission('sinistre_douteux') || $user->role_id == 4) {
            return true;
        }
    }

    public function status(User $user)
    {
        if ($user->hasPermission('status_dossiers') || $user->hasRolePermission('status_dossiers') || $user->role_id == 4) {
            return true;
        }
    }

    public function link(User $user)
    {
        if ($user->hasPermission('lienExternes') || $user->hasRolePermission('lienExternes') || $user->role_id == 4) {
            return true;
        }
    }

    public function fullaccess(User $user)
    {
        if ($user->hasPermission('acces_total_dossiers') || $user->hasRolePermission('acces_total_dossiers') || $user->role_id == 4) {
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if ($user->role_id == 4 || $user->hasPermission('supprimer_dossiers') || $user->hasRolePermission('supprimer_dossiers') ) {
            return true;
        }
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Dossier $dossier)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Dossier $dossier)
    {
        //
    }
}
