<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;

use App\Models\Dossier;
use App\Models\Meeting;
use App\Models\Ticket;
use App\Policies\DossierPolicy;
use App\Policies\MeetingPolicy;
use App\Policies\TicketPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Dossier::class => DossierPolicy::class,
        Meeting::class => MeetingPolicy::class,
        Ticket::class => TicketPolicy::class,

    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        //
    }
}
