<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dossiers', function (Blueprint $table) {

            $table->id();
            $table->string('ref')->unique()->nullable();
            $table->foreignId('insured_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('opponent_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('company_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('guarantee_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('type_expertise_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('dossier_status_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('vehicule_model_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('intermidiaire_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('mode_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('garage_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('step_id')->nullable()->constrained()->onDelete(null);
            $table->string('matricule')->nullable();
            $table->string('new_matricule')->nullable();
            $table->string('numero_sinistre')->nullable();
            $table->string('numero_chassis')->nullable();
            $table->string('numero_attestation')->nullable();
            $table->string('puissance_fiscale')->nullable();
            $table->string('numero_police')->nullable();
            $table->boolean('sinistre_douteux')->default(false);
            $table->date('date_sinistre');
            $table->date('date_circulation')->nullable();
            $table->date('date_fin')->nullable();
            $table->date('date_reception')->nullable();
            $table->string('kilometrage')->nullable();
            // $table->date('from')->nullable();
            // $table->date('to')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dossiers');
    }
};
