<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_company_type', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete(null);
            $table->foreignId('user_id')->constrained()->onDelete(null);
            $table->foreignId('type_expertise_id')->nullable()->constrained()->onDelete(null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_company_type');
    }
};
