    <style>
        .img {
            height: 240px;
            width: auto;
            object-fit: contain;
            padding: 10px;
        }

        /* Position the image container (needed to position the left and right arrows) */
        .container {
            position: relative;
        }

        /* Hide the images by default */
        .mySlides {
            display: none;
        }

        /* Add a pointer when hovering over the thumbnail images */
        .cursor {
            cursor: pointer;
        }

        /* Next & previous buttons */
        .prev,
        .next {
            margin: 0 25px;
            cursor: pointer;
            position: absolute;
            /* top: 35%; */
            width: auto;
            padding: 6px;
            margin-top: -250px;
            color: #0000FF;
            font-weight: bold;
            font-size: 20px;
            border-radius: 0 3px 3px 0;
            user-select: none;
            -webkit-user-select: none;

        }

        .prev {
            margin: -250px -12px 0;
        }

        /* Position the "next button" to the right */
        .next {
            right: 0;
            border-radius: 3px 0 0 3px;
        }

        /* On hover, add a black background color with a little bit see-through */
        .prev:hover,
        .next:hover {
            background-color: rgba(0, 0, 0, 0.8);
        }

        /* Number text (1/3 etc) */
        .numbertext {
            color: #f2f2f2;
            font-size: 12px;
            padding: 8px 12px;
            position: absolute;
            top: 0;
        }

        /* Container for image text */
        .caption-container {
            text-align: center;
            background-color: #222;
            padding: 2px 16px;
            color: white;
        }

        /* .row:after {
                                                            content: "";
                                                            display: table;
                                                            clear: both;
                                                        } */

        /* Six columns side by side */
        .column {
            float: left;
            width: 16.66%;
        }

        /* Add a transparency effect for thumnbail images */
        .demo {
            opacity: 0.6;
        }

        .active,
        .demo:hover {
            opacity: 1;
        }

        .form-select {
            display: inline-block;
        }


    </style>

    <div class="container-fluid mt-3 mb-2">
        <div class="row m-0 p-0 ">
            <div class="col-md-6 p-0">
                <div class="row m-0">
                    <div class="col-md-12 p-0">
                        <input type="hidden" id="src"
                            value="<?php echo e(Storage::disk('s3')->temporaryUrl($document->path, now()->addMinutes(30)) ?? null); ?>">
                        <div style="margin: 5%" id="editor">
                            <canvas id="c" width="1" height="1" style="border: 1px dotted #CCCCCC;">
                            </canvas>
                        </div>


                        <div class="col-md-12 mt-3">
                            <div class="row py-2">
                                <div class="col-sm-1 me-1">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <button id="drawing-mode" class="btn btn-outline-dark rounded-pill">
                                                <i class="dripicons-brush" style="font-size: 20px;"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-8">
                                    <div class="row" id="toolbox">
                                        <div class="col-sm-12 px-2">

                                            <button class="btn btn-outline-dark rounded-pill mx-1 ms-5"
                                                id="toolbox-remove-element">
                                                <i class="uil uil-multiply" style="font-size: 20px;"></i>
                                            </button>
                                            <button class="btn btn-outline-dark rounded-pill mx-1"
                                                id="toolbox-clear-canvas">
                                                <i class="dripicons-trash" style="font-size: 20px;"></i>
                                            </button>
                                            <button onClick="addHorizontalLine();"
                                                class="btn btn-outline-dark rounded-pill mx-1">
                                                <i class="" style="font-size: 20px;"></i></button>
                                            <button name="edito" onClick="editor.addTextBox('Text')"
                                                class="btn btn-outline-dark rounded-pill mx-1">
                                                <i class="uil uil-text-size" style="font-size: 20px;"></i></button>
                                            <input id="toolbox-color" type="color" autocomplete="off"
                                                class="form-control form-control-color d-inline-block mx-1"
                                                style="margin-top: 2px !important;
                                                z-index: 9999;
                                                position: absolute;">

                                        </div>
                                        <div class="col-md-12 mt-2" style="display: flex">
                                            <input class="form-control mx-1" type="text" id="text-input">
                                            <input class="form-control mx-1" type="number" id="size-input"
                                                min="1">
                                            <button class="btn btn-dark" onclick="addText()">
                                                <i class="uil uil-text rounded-pill mx-1" style="font-size: 20px;"></i>
                                            </button>

                                        </div>

                                        <div class="col-md-12 mt-2">

                                            <button id="watermark" class="btn btn-outline-dark rounded-pill mx-1">
                                                <i class="uil uil-file-edit-alt"style="font-size: 20px;"></i>
                                            </button>
                                            <select id="select" class="form-select w-50 rounded-pill"
                                                aria-label="Default select example" onchange="signiature()">
                                                <option value="1.png">PV</option>
                                                <option value="22.png">-</option>
                                                <option value="2.png">SRSV</option>
                                                <option value="3.png">Companie</option>
                                                <option value="4.png">CID</option>
                                                <option value="5.png">USUR</option>
                                                <option value="6.png">COLLEGIALE</option>
                                                <option value="7.png">ORIGINE</option>
                                                <option value="8.png">AMEA</option>
                                                <?php if(Auth::user()->role_id == 4): ?>
                                                    <option value="9.png">Signer</option>
                                                <?php endif; ?>
                                            </select>

                                            
                                            <img id="1.png" src="<?php echo e(asset('img/Amea signature/1.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="22.png" src="<?php echo e(asset('img/Amea signature/22.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="2.png" src="<?php echo e(asset('img/Amea signature/2.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="3.png" src="<?php echo e(asset('img/Amea signature/3.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="4.png" src="<?php echo e(asset('img/Amea signature/4.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="5.png" src="<?php echo e(asset('img/Amea signature/5.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="6.png" src="<?php echo e(asset('img/Amea signature/6.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="7.png" src="<?php echo e(asset('img/Amea signature/7.png')); ?>"
                                                alt="" style="display: none">
                                            <img id="8.png" src="<?php echo e(asset('img/Amea signature/8.png')); ?>"
                                                alt="" style="display: none">
                                            <?php if(Auth::user()->role_id == 4): ?>
                                                <img id="9.png" src="<?php echo e(asset('img/sign.png')); ?>" alt=""
                                                    style="display: none">
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-1">
                                    <button onClick="editor.download()"
                                        class="btn btn-outline-success rounded-pill"><i class="dripicons-checkmark"
                                            style="font-size: 20px;"></i></button>
                                </div>
                            </div>
                            <div class="row px-2" id="drawing-mode-options">
                                <div class="col-sm-6 m-0 p-0">
                                    <label for="drawing-line-width">Largeur de Peinture:</label>
                                    <span class="info">5</span>
                                    <input type="range" class="form-range" value="5" min="0"
                                        max="150" id="drawing-line-width" autocomplete="off">
                                </div>
                                <div class="col-sm-6 ">
                                    <label for="drawing-color" class="d-inline-block">Couleur de la Peinture:</label>
                                    <input type="color" class="form-control form-control-color d-inline-block"
                                        value="#003399" id="drawing-color" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 p-0">
                <div class="mb-1">
                    <a class="btn btn-primary" onclick="plusSlides(-1)">❮</a>
                    <a class="btn btn-primary" onclick="plusSlides(1)">❯</a>
                </div>
                <div class="container-fluid p-0 m-0">

                    <?php $__currentLoopData = $dossier->document; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mySlides  m-0">
                            <img src="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                                data-original="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                                style="width:100% !important;">
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <a class="prev" onclick="plusSlides(-1)">❮</a>
                    <a class="next" onclick="plusSlides(1)">❯</a>

                    <div class="row m-0">
                        <div style="display: none;">
                            <?php echo e($i = 1); ?>

                        </div>
                        <?php $__currentLoopData = $dossier->document; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="column">
                                <img class="demo cursor"
                                    src="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                                    style="width:100%" onclick="currentSlide(<?php echo e($i); ?>)">
                            </div>
                            <div style="display: none;">
                                <?php echo e($i++); ?>

                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <form id="myForm" action="<?php echo e(route('Document.update', $document->id)); ?>" method="post">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <input type="hidden" name="img" value="" id="edited">
        <input type="hidden" name="width" value="<?php echo e($document->width ?? 0); ?>" id="width">
        <input type="hidden" name="height" value="<?php echo e($document->height ?? 0); ?>" id="height">

    </form>
    <?php $__env->startSection('script'); ?>
        <script src="<?php echo e(asset('js/fabric/fabric.js')); ?>"></script>
        <script src="<?php echo e(asset('js/fabric/fabric.arrow.js')); ?>"></script>
        <script src="<?php echo e(asset('js/fabric/smart-framework.pak.js')); ?>"></script>
        <script src="<?php echo e(asset('js/fabric/fabric-editor.js')); ?>"></script>
        <script src="<?php echo e(asset('js/viewer.js')); ?>"></script>
        <script>
            let btns = document.getElementById('watermark');

            function signiature() {
                let select = document.getElementById('select').value;
                let img = document.getElementById(select).src;
                return img
                // editor.addImage(img, 100, 100, false);
            }
            btns.addEventListener('click', function() {
                let sin = signiature();
                editor.addImage(sin, 100, 100, false);
            });
        </script>
        <script>
            let slideIndex = 1;
            showSlides(slideIndex);

            function plusSlides(n) {
                showSlides(slideIndex += n);
            }

            function currentSlide(n) {
                showSlides(slideIndex = n);
            }

            function showSlides(n) {
                let i;
                let slides = document.getElementsByClassName("mySlides");
                let dots = document.getElementsByClassName("demo");
                if (n > slides.length) {
                    slideIndex = 1
                }
                if (n < 1) {
                    slideIndex = slides.length
                }
                for (i = 0; i < slides.length; i++) {
                    slides[i].style.display = "none";
                }
                for (i = 0; i < dots.length; i++) {
                    dots[i].className = dots[i].className.replace(" active", "");
                }
                slides[slideIndex - 1].style.display = "block";
                dots[slideIndex - 1].className += " active";
            }
        </script>
        <script>
            var width = document.getElementById('width').value;
            var height = document.getElementById('height').value;

            var image = document.getElementById('src').value;
            console.log(image);
            var editor = new Smart_FabricJs_EditCanvas('c', image, width, height, '#FFFFFF');
            var canvas = editor.getCanvas();
            canvas.requestRenderAll();
            canvas.on('mouse:down', function(options) {
                var event = options.e;
                var mousePosX = event.clientX - canvas._offset.left;
                var mousePosY = event.clientY - canvas._offset.top;

                // Prompt the user for the text
                var text = 'test';
                if (text) {
                    // Create a new Text object at the clicked position
                    var textObj = new fabric.Text(text, {
                        left: mousePosX,
                        top: mousePosY,
                    });

                    // Add the text to the canvas
                    canvas.add(textObj);
                }
            });

            function addHorizontalLine() {
                var line = new fabric.Line([50, 100, 250, 100], {
                    stroke: 'black',
                    strokeWidth: 3
                });

                canvas.add(line);
            }

            function addText() {
                var text = document.getElementById('text-input').value;
                var color = document.getElementById('toolbox-color').value;
                var size = parseInt(document.getElementById('size-input').value);

                var textObj = new fabric.Textbox(text, {
                    left: 50,
                    top: 50,
                    fill: color,
                    fontSize: size
                });

                canvas.add(textObj);
            }
            $('#toolbox-clear-canvas').on('click', function() {
                var ok = confirm('Effacer la zone de dessin ?');
                if (ok) {
                    editor.clearCanvas();
                }
                return false;
            });

            $('#toolbox-remove-element').on('click', function() {
                //--
                var ok = confirm("Supprimer l'élément sélectionné de la zone de dessin?");
                if (ok) {
                    editor.removeSelected();
                }
                //--
                return false;
                //--
            });
            $('#toolbox-color').on('change', function() {
                //--
                var val = $(this).val();
                //	console.log(val);
                if (!val) {
                    return;
                } //end if
                editor.setColorOnSelected('fill', val);
                //--
                return false;
                //--
            });

            $('#toolbox-scolor').on('change', function() {
                //--
                var val = $(this).val();
                //	console.log(val);
                if (!val) {
                    return;
                } //end if
                editor.setColorOnSelected('stroke', val);
                //--
                return false;
                //--
            });

            (function() {
                var theTextureImage = '<?php echo e(asset('js/fabric/server.svg')); ?>';
                var isCanvasDrawingMode = null;
                var drawingModeEl = $('#drawing-mode'),
                    drawingOptionsEl = $('#drawing-mode-options'),
                    drawingColorEl = $('#drawing-color'),
                    drawingShadowColorEl = $('#drawing-shadow-color'),
                    drawingLineWidthEl = $('#drawing-line-width'),
                    drawingShadowWidth = $('#drawing-shadow-width'),
                    drawingShadowOffset = $('#drawing-shadow-offset');
                drawingModeEl.on('click', function() {
                    if (isCanvasDrawingMode === null) {
                        isCanvasDrawingMode = false;
                    } else {
                        isCanvasDrawingMode = !isCanvasDrawingMode;
                    }
                    if (isCanvasDrawingMode) {
                        $('#toolbox').hide();
                        drawingModeEl.html('<i class="dripicons-return" style="font-size: 20px;"></i>');
                        drawingOptionsEl.show();
                    } else {
                        $('#toolbox').show();
                        drawingModeEl.html('<i class="dripicons-brush" style="font-size: 20px;"></i>');
                        drawingOptionsEl.hide();
                    }
                    editor.canvasToggleDrawingMode(!!isCanvasDrawingMode);
                }).trigger('click');

                if (fabric.PatternBrush) {

                    var vLinePatternBrush = new fabric.PatternBrush(canvas);

                    vLinePatternBrush.getPatternSrc = function() {

                        var patternCanvas = fabric.document.createElement('canvas');
                        patternCanvas.width = patternCanvas.height = 10;
                        var ctx = patternCanvas.getContext('2d');

                        ctx.strokeStyle = this.color;
                        ctx.lineWidth = 5;
                        ctx.beginPath();
                        ctx.moveTo(0, 5);
                        ctx.lineTo(10, 5);
                        ctx.closePath();
                        ctx.stroke();

                        return patternCanvas;
                    };

                    var hLinePatternBrush = new fabric.PatternBrush(canvas);
                    hLinePatternBrush.getPatternSrc = function() {

                        var patternCanvas = fabric.document.createElement('canvas');
                        patternCanvas.width = patternCanvas.height = 10;
                        var ctx = patternCanvas.getContext('2d');

                        ctx.strokeStyle = this.color;
                        ctx.lineWidth = 5;
                        ctx.beginPath();
                        ctx.moveTo(5, 0);
                        ctx.lineTo(5, 10);
                        ctx.closePath();
                        ctx.stroke();

                        return patternCanvas;
                    };

                    var squarePatternBrush = new fabric.PatternBrush(canvas);
                    squarePatternBrush.getPatternSrc = function() {

                        var squareWidth = 10,
                            squareDistance = 2;

                        var patternCanvas = fabric.document.createElement('canvas');
                        patternCanvas.width = patternCanvas.height = squareWidth + squareDistance;
                        var ctx = patternCanvas.getContext('2d');

                        ctx.fillStyle = this.color;
                        ctx.fillRect(0, 0, squareWidth, squareWidth);

                        return patternCanvas;
                    };

                    var diamondPatternBrush = new fabric.PatternBrush(canvas);
                    diamondPatternBrush.getPatternSrc = function() {

                        var squareWidth = 10,
                            squareDistance = 5;
                        var patternCanvas = fabric.document.createElement('canvas');
                        var rect = new fabric.Rect({
                            width: squareWidth,
                            height: squareWidth,
                            angle: 45,
                            fill: this.color
                        });

                        var canvasWidth = rect.getBoundingRect().width;

                        patternCanvas.width = patternCanvas.height = canvasWidth + squareDistance;
                        rect.set({
                            left: canvasWidth / 2,
                            top: canvasWidth / 2
                        });

                        var ctx = patternCanvas.getContext('2d');
                        rect.render(ctx);

                        return patternCanvas;
                    };

                    var img = new Image();
                    var texturePatternBrush = null;
                    img.onload = function() {
                        texturePatternBrush = new fabric.PatternBrush(canvas);
                        texturePatternBrush.source = this;
                    };
                    img.src = String(theTextureImage);

                }

                $('#drawing-mode-selector').on('change', function() {
                    //--
                    theVal = $(this).val() || '';
                    //--
                    switch (theVal.toLowerCase()) {
                        case 'hline':
                            canvas.freeDrawingBrush = hLinePatternBrush;
                            break;
                        case 'vline':
                            canvas.freeDrawingBrush = vLinePatternBrush;
                            break;
                        case 'square':
                            canvas.freeDrawingBrush = squarePatternBrush;
                            break;
                        case 'diamond':
                            canvas.freeDrawingBrush = diamondPatternBrush;
                            break;
                        case 'texture':
                            if (texturePatternBrush) {
                                canvas.freeDrawingBrush = texturePatternBrush;
                            } else {
                                console.error('Cannot Load Pattern Image: ' + theTextureImage);
                            }
                            break;
                        default:
                            try {
                                canvas.freeDrawingBrush = new fabric[theVal.charAt(0).toUpperCase() + theVal
                                    .slice(
                                        1) + 'Brush'](canvas);
                            } catch (err) {
                                console.error('Error: ' + err);
                                return;
                            }
                    } //end switch
                    //--
                    if (canvas.freeDrawingBrush) {
                        canvas.freeDrawingBrush.color = drawingColorEl.val();
                        canvas.freeDrawingBrush.width = parseInt(drawingLineWidthEl.val(), 10) || 1;
                        canvas.freeDrawingBrush.shadow = new fabric.Shadow({
                            blur: parseInt(drawingShadowWidth.val(), 10) || 0,
                            offsetX: 0,
                            offsetY: 0,
                            affectStroke: true,
                            color: drawingShadowColorEl.val(),
                        });
                    }
                    //--
                });

                drawingColorEl.on('change', function() {
                    canvas.freeDrawingBrush.color = $(this).val();
                });
                drawingShadowColorEl.on('change', function() {
                    canvas.freeDrawingBrush.shadow.color = $(this).val();
                });
                drawingLineWidthEl.on('change', function() {
                    canvas.freeDrawingBrush.width = parseInt($(this).val(), 10) || 1;
                    $(this).prev().text($(this).val());
                });
                drawingShadowWidth.on('change', function() {
                    canvas.freeDrawingBrush.shadow.blur = parseInt($(this).val(), 10) || 0;
                    $(this).prev().text($(this).val());
                });
                drawingShadowOffset.on('change', function() {
                    canvas.freeDrawingBrush.shadow.offsetX =
                        canvas.freeDrawingBrush.shadow.offsetY = parseInt($(this).val(), 10) || 0;
                    $(this).prev().text($(this).val());
                });

                if (canvas.freeDrawingBrush) {
                    canvas.freeDrawingBrush.color = drawingColorEl.val();
                    canvas.freeDrawingBrush.width = parseInt(drawingLineWidthEl.val(), 10) || 1;
                    canvas.freeDrawingBrush.shadow = new fabric.Shadow({
                        blur: parseInt(drawingShadowWidth.val(), 10) || 0,
                        offsetX: 0,
                        offsetY: 0,
                        affectStroke: true,
                        color: drawingShadowColorEl.val(),
                    });
                }
            })();
        </script>
        <script>
            window.addEventListener('load', function() {
                var galley = document.getElementById('galley');
                var maxOffsetPercentage = 0.9;
                var viewer = new Viewer(galley, {
                    url: 'data-original',
                    backdrop: 'static',
                    move: function(event) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var detail = event.detail;
                        var left = detail.x;
                        var top = detail.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        if (
                            // Move left
                            (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                            // Move right
                            ||
                            (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                            // Move up
                            ||
                            (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                            // Move down
                            ||
                            (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                        ) {
                            event.preventDefault();
                        }
                    },
                    zoomed: function(event) {
                        var detail = event.detail;
                        // Zoom out
                        if (detail.ratio < detail.oldRatio) {
                            var viewerData = viewer.viewerData;
                            var imageData = viewer.imageData;
                            var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                            var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                            var left = imageData.x;
                            var top = imageData.y;
                            var right = viewerData.width - (left + imageData.width);
                            var bottom = viewerData.height - (top + imageData.height);
                            var x = 0;
                            var y = 0;
                            if (right > 0 && right > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - right;
                            }
                            if (left > 0 && left > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - left;
                            }

                            if (bottom > 0 && bottom > maxOffsetVertical) {
                                y = bottom - maxOffsetVertical;
                            }

                            if (top > 0 && top > maxOffsetVertical) {
                                y = top - maxOffsetVertical;
                            }

                            // Move the image into view if it is invisible
                            if (x !== 0 || y !== 0) {
                                viewer.move(x, y);
                            }
                        }
                    },
                });
            });
            var links = document.getElementsByClassName('link');
            for (var i = 0; i < links.length; i++) {

                links[i].addEventListener('click', function() {
                    var galley = document.getElementById('galley');
                    var maxOffsetPercentage = 0.9;
                    var viewer = new Viewer(galley, {
                        url: 'data-original',
                        backdrop: 'static',
                        move: function(event) {
                            var viewerData = viewer.viewerData;
                            var imageData = viewer.imageData;
                            var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                            var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                            var detail = event.detail;
                            var left = detail.x;
                            var top = detail.y;
                            var right = viewerData.width - (left + imageData.width);
                            var bottom = viewerData.height - (top + imageData.height);
                            if (
                                // Move left
                                (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                                // Move right
                                ||
                                (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                                // Move up
                                ||
                                (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                                // Move down
                                ||
                                (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                            ) {
                                event.preventDefault();
                            }
                        },
                        zoomed: function(event) {
                            var detail = event.detail;
                            // Zoom out
                            if (detail.ratio < detail.oldRatio) {
                                var viewerData = viewer.viewerData;
                                var imageData = viewer.imageData;
                                var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                                var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                                var left = imageData.x;
                                var top = imageData.y;
                                var right = viewerData.width - (left + imageData.width);
                                var bottom = viewerData.height - (top + imageData.height);
                                var x = 0;
                                var y = 0;
                                if (right > 0 && right > maxOffsetHorizontal) {
                                    x = maxOffsetHorizontal - right;
                                }
                                if (left > 0 && left > maxOffsetHorizontal) {
                                    x = maxOffsetHorizontal - left;
                                }

                                if (bottom > 0 && bottom > maxOffsetVertical) {
                                    y = bottom - maxOffsetVertical;
                                }

                                if (top > 0 && top > maxOffsetVertical) {
                                    y = top - maxOffsetVertical;
                                }

                                // Move the image into view if it is invisible
                                if (x !== 0 || y !== 0) {
                                    viewer.move(x, y);
                                }
                            }
                        },
                    });
                });
            }
        </script>
        <script>
            //attach
            $(document).ready(function() {

                $(".savedevis").click(function(event) {
                    event.preventDefault();

                    var checkedRowIndices = [];
                    var checkedRowIndices1 = [];
                    var checkedRowIndices2 = [];
                    var qtes = [];
                    var vetustes = [];
                    var remises = [];


                    $('input[type=checkbox]').each(function(value) {

                        if ($(this)[0].checked) {

                            checkedRowIndices.push($(this)[0].value);
                            qtes.push($("#id" + $(this)[0].value).val());
                            vetustes.push($("#v" + $(this)[0].value).val());
                            remises.push($("#r" + $(this)[0].value).val());

                        }


                    });



                    // console.log(checkedRowIndices);

                    let qte = qtes;
                    let piece = checkedRowIndices;
                    let devis_id = $("input[name=devis_id]").val();
                    let vetuste = vetustes;
                    let remise = remises;
                    let _token = $('meta[name="csrf-token"]').attr('content');

                    console.log(piece);
                    console.log(qte);

                    $.ajax({
                        url: "/Devis/attach",
                        type: "POST",
                        data: {
                            piece: piece,
                            devis_id: devis_id,
                            qte: qte,
                            vetuste: vetustes,
                            remise: remises,
                            _token: _token
                        },
                        success: function(response) {
                            console.log(response);
                            if (response) {
                                $('.success').text(response.success);
                                alert('enregistrer');
                            }
                        },
                    });
                });
            });
        </script>
    <?php $__env->stopSection(); ?>
<?php /**PATH C:\laragon\www\engi.ameamaroc.ma\resources\views/devis/editor_devis.blade.php ENDPATH**/ ?>