<?php $__env->startSection('style'); ?>
    <style>
        .img-fluid {
            height: 260px;
            width: auto;
            object-fit: contain;
            padding: 10px
                /* object-position: center; */
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('pdf.technique', $dossier->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="row g-4 mt-2">
            <h4>Selectionner Une photo de Voiture :</h4>
            <?php $__currentLoopData = $docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-3">
                    <span> <?php echo e($doc->typedocument->type ?? null); ?></span>
                    <div class="card h-100">
                        <input class="image-checkbox" data-image-url="<?php echo e($doc->id); ?>" type="checkbox" name=""
                            id="">
                        <img src="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                            class="card-img-top img-fluid">
                        <input type="hidden" name="img[]"
                            value="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                            id="<?php echo e($doc->id); ?>">
                        <div class="card-body">
                            <textarea name="body[]" class="form-control" id="" cols="30" rows=5></textarea>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <input type="hidden" name="voiture" id="voiture">

            <div class="col-12">
                <div class="col-6 mt-1">
                    <label for="">Conclusion</label>
                    <textarea required class="form-control" name="conclusion" id="" cols="30" rows="10"></textarea>
                </div>
                <div class="col-6 mt-3">
                    <label for="">Total des Dommages</label>
                    <input required class="form-control" min="0" type="number" value="0" name="dommage">
                </div>
            </div>
            <div class="col-6">
                <input type="submit" class="btn btn-success" value="Enregistrer">
            </div>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const checkboxes = document.querySelectorAll('.image-checkbox');

            checkboxes.forEach(function(checkbox) {
                checkbox.addEventListener('change', function() {
                    checkboxes.forEach(function(otherCheckbox) {
                        if (otherCheckbox !== checkbox) {
                            otherCheckbox.checked = false;
                        }
                    });

                    if (checkbox.checked) {
                        const imageUrl = checkbox.getAttribute('data-image-url');
                        document.getElementById('voiture').value = imageUrl;

                        console.log('Image URL:', imageUrl); // Replace with your desired action
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\engi.ameamaroc.ma\resources\views/dossiers/reformeTechnique.blade.php ENDPATH**/ ?>