@extends('layouts.dashboard.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header mt-2">Ref Dossier : {{ $dossier->ref }}</div>

                    <div class="card-body">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        @if ($user->role_id === 4)
                            @if ($classes)
                                <h3>les Appel actuellement disponibles</h3>
                                @foreach ($classes as $key => $class)
                                        <h6>{{ $class->name }}</h6>
                                    <br />
                                @endforeach
                            @endif
                            <h4> Bienvenue {{ $user->name }}.Remplissez le formulaire ci-dessous pour créer une appel </h4>
                            <form method="POST" action="{{ route('create_class') }}">
                                @csrf

                                <div class="form-group row">
                                    <label for="name" class="col-md-12 col-form-label">{{ __('Reunion') }}</label>

                                    <div class="col-md-6">
                                        <input id="name" type="text"
                                            class="form-control @error('name') is-invalid @enderror" name="name"
                                            value="{{ old('name') }}" required autocomplete="name" autofocus>

                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror

                                    </div>
                                </div>
                                <input type="hidden" name="dossier_id" value="{{ $dossier_id }}">
                                <div class="form-group  mt-2">
                                    <div class="col-md-6" style="float: left">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('Créer Reunion') }}
                                        </button>
                                    </div>
                                </div>
                                <div class="form-group  mt-2">
                                    <div class="col-md-6" style="float: right">
                                        <a class="btn btn-outline-primary" href="{{ route('call.saved',$dossier_id) }}">
                                             {{ __('Consulter Reunion Enregistrer') }}
                                        </a>
                                    </div>
                                </div>
                            </form>

                        @endif

                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
