@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Libelle</th>
                                        <th>Email</th>
                                        <th>Adresse</th>
                                        <th>Ville</th>
                                        <th>Agreer</th>
                                        <th>Site</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $garage->id }}</td>
                                        <td>{{ $garage->libelle ?? null }}</td>
                                        <td>{{ $garage->email ?? null }}</td>
                                        <td>{{ $garage->adress ?? null }}</td>
                                        <td>{{ $garage->city->city ?? null }}</td>
                                        <td>
                                            {{ $garage->tel ?? null }}
                                        </td>
                                        <td> <a class="btn btn-sm btn-dark rounded-pill" target="_blank"
                                                href="{{ $garage->url }}">Site</a>
                                        </td>
                                        @can('update', $garage)
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Garage.edit', [$garage->id]) }}"><i
                                                        class="uil uil-pen fs-5">
                                                    </i></a>
                                            </td>
                                        @endcan
                                        @can('delete', $garage)
                                            <td>
                                                <form action="{{ route('Garage.destroy', [$garage->id]) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit"><i
                                                            class="uil uil-trash fs-5"></i></button>
                                                </form>
                                            </td>
                                        @endcan

                                    </tr>
                                </tbody>
                                <input type="hidden" value="{{ $garage->lat }}" name="lat" id="lat">
                                <input type="hidden" value="{{ $garage->lng }}" name="lng" id="lng">

                            </table>
                        </div>
                        <form action="{{ route('GarageCompany.asign', $garage->id) }}" method="POST" class="mb-4">
                            @csrf
                            <div class="col-md-12 mr-2 mb-2 mt-1">
                                <h4>Agréer par :</h4>
                                <hr>
                                @forelse ($companies as $company)
                                    @if ($garage->hascompany($company->company))
                                        <div class="form-check form-check-inline form-checkbox-primary ">
                                            <input type="checkbox" checked class="form-check-input"
                                                value="{{ $company->id }}" name="company[]"
                                                id="customSwitch3{{ $company->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $company->id }}">{{ $company->company }}</label>
                                        </div>
                                    @else
                                        <div class="form-check form-check-inline form-checkbox-dark ">
                                            <input type="checkbox" class="form-check-input" value="{{ $company->id }}"
                                                name="company[]" id="customSwitch3{{ $company->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $company->id }}">{{ $company->company }}</label>
                                        </div>
                                    @endif

                                @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse


                            </div>
                            @can('update', $garage)
                                <button style="float:right" type="submit" class="btn btn-outline-primary mb-">Asigner
                                    Companie</button>
                            @endcan
                        </form>
                        <form action="{{ route('GarageService.asign', $garage->id) }}" method="POST" class="mb-4">
                            @csrf
                            <div class="col-md-12 mr-2 mb-2 mt-1">
                                <h4>Assigner un Service</h4>
                                <hr>
                                @forelse ($services as $service)
                                    @if ($garage->hasService($service->service))
                                        <div class="form-check form-check-inline form-checkbox-success ">
                                            <input type="checkbox" checked class="form-check-input"
                                                value="{{ $service->id }}" name="service[]"
                                                id="customSwitch3{{ $service->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $service->id }}">{{ $service->service }}</label>
                                        </div>
                                    @else
                                        <div class="form-check form-check-inline form-checkbox-warning ">
                                            <input type="checkbox" class="form-check-input" value="{{ $service->id }}"
                                                name="service[]" id="customSwitch3{{ $service->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $service->id }}">{{ $service->service }}</label>
                                        </div>
                                    @endif

                                @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse


                            </div>
                            @can('update', $garage)
                                <button style="float:right" type="submit" class="btn btn-outline-success mb-">Asigner
                                    Service</button>
                            @endcan
                        </form>
                        <div class="col-md-12 mt-3">
                            <h3>Localisation :</h3>
                            <hr>
                            <div id="map" class="gmaps" style="height: 60vh">
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&callback=initMap" async defer>
    </script>
    <script>
        let map;

        function initMap() {
            map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: parseFloat($('#lat').val()),
                    lng: parseFloat($('#lng').val())
                },
                zoom: 13,
                scrollwheel: true,
            });
            const uluru = {
                lat: parseFloat($('#lat').val()),
                lng: parseFloat($('#lng').val())
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });

        }

        window.initMap = initMap;
    </script>
@endsection
