@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Ajouter Une Piece</h5>
                    </div>
                    <div class="card-body mt-1">
                        <form action="{{ route('Piece.store') }}" method="post">
                            @csrf

                            <div class="col-6 mb-2">
                                <label for="brand">Type Piece</label>
                                <select name="piece_type_id" id="piece_type_id"
                                    class="form-control @error('piece_type_id') is-invalid @enderror">
                                    <option value="">Selectioner Un Type</option>
                                    @foreach ($piecetypes as $type)
                                        <option value="{{ $type->id }}">
                                            {{ $type->type }}</option>
                                    @endforeach
                                </select>
                                @error('piece_type_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-2">
                                <label for="piece">Piéce</label>
                                <input type="text" name="piece" value="{{ old('piece') }}" required
                                    class="form-control @error('piece') is-invalid @enderror">
                                @error('piece')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            {{-- <div class="form-group mb-2">
                                <label for="mode">Mode</label>
                                <select class="form-select  @error('mode') is-invalid @enderror" name="mode"
                                    id="mode">
                                    @foreach ($modes as $mode)
                                        <option value="{{ $mode->id }}">{{ $mode->mode }}</option>
                                    @endforeach
                                </select>
                                @error('mode')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div> --}}
                            {{-- <div class="form-group mb-2">
                                <div class="col-6 mb-2">
                                    <label for="brand">Marque</label>
                                    <select name="brand_id" id="brand_id"
                                        class="form-control @error('brand_id') is-invalid @enderror">
                                        <option value="">Selectioner Une Marque</option>
                                        @foreach ($brands as $brand)
                                            <option data-brand-id='{{ $brand->id }}' value="{{ $brand->id }}">
                                                {{ $brand->brand }}</option>
                                        @endforeach
                                    </select>
                                    @error('brand_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-6 mb-2">
                                    <label for="model">Vehicule</label>
                                    <select name="vehicule_model_id" id="vehicule_model_id"
                                        class="form-control @error('vehicule_model_id') is-invalid @enderror">
                                    </select>
                                    @error('vehicule_model_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group mb-2">
                                <label for="prix_unitaire">Prix Unitaire</label>
                                <input type="text" name="prix_unitaire" required
                                    class="form-control @error('prix_unitaire') is-invalid @enderror">
                                @error('prix_unitaire')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="col-6 mb-2">
                                <label for="brand">Type Reparation</label>
                                <select name="type_reparation_id" id="type_reparation_id"
                                    class="form-control @error('type_reparation_id') is-invalid @enderror">
                                    <option value="">Selectioner Un Type</option>
                                    @foreach ($types as $type)
                                        <option value="{{ $type->id }}">
                                            {{ $type->type }}</option>
                                    @endforeach
                                </select>
                                @error('type_reparation_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-6 mb-2">
                                <label for="brand">Piece Operation</label>
                                <select name="operation" id="operation"
                                    class="form-control @error('operation') is-invalid @enderror">
                                    <option value="">Selectioner Un Type</option>
                                    @foreach ($operations as $operation)
                                        <option value="{{ $operation->id }}">
                                            {{ $operation->operation }}</option>
                                    @endforeach
                                </select>
                                @error('operation')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div> --}}


                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Créer</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function() {

            $('#brand_id').on('change', function() {
                var brand_id = this.value;
                // $("#state-dd").html('');
                console.log(12);
                $.ajax({
                    url: '/Vehicule/' + brand_id,
                    type: 'get',
                    success: function(result) {
                        $('#vehicule_model_id').html(
                            '<option  value="">Selectionner Modele </option>');
                        $.each(result, function(key, value) {

                            $("#vehicule_model_id").append('<option  value="' + value
                                .id + '">' + value.name + '</option>');
                        });
                    }
                });
            });
        });
    </script>
@endsection
