@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des Compagnies</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>ICE</th>
                                        <th>Compagnie</th>
                                        <th>Email</th>
                                        <th>Email ENGI</th>
                                        <th>Telephone</th>
                                        <th>Adresse</th>
                                        <th>Afficher</th>
                                        <th>Modifier</th>
                                        {{-- <th>Supprimer</th> --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($companies as $company)
                                        <tr>
                                            <td>{{ $company->id }}</td>
                                            <td>{{ $company->ice ?? null }}</td>
                                            <td>{{ $company->company ?? null }}</td>
                                            <td>{{ $company->email ?? null}}</td>
                                            <td>{{ $company->email_pro ?? null}}</td>
                                            <td>{{ $company->phone ?? null}}</td>
                                            <td>{{ $company->adress ?? null}}</td>

                                            <td>
                                                @can('view', App\Models\Company::class)
                                                    <a class="btn btn-sm btn-info rounded-pill"
                                                        href="{{ route('Company.show', [$company->id]) }}"><i
                                                            class="uil uil-eye fs-5"></i></a>
                                                @endcan
                                            </td>
                                            <td>
                                                @can('update', App\Models\Company::class)
                                                    <a class="btn btn-sm btn-primary rounded-pill"
                                                        href="{{ route('Company.edit', [$company->id]) }}"><i
                                                            class="uil uil-pen fs-5"></i></a>
                                                @endcan
                                            </td>

                                            {{-- <td>
                                                @can('delete', App\Models\Company::class)
                                                    <form action="{{ route('Company.destroy', [$company->id]) }}"
                                                        method="post">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                            <i class="uil uil-trash fs-5"></i>
                                                        </button>
                                                    </form>
                                                @endcan
                                            </td> --}}

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
