@extends('layouts.dashboard.app')
@section('style')
    <style>
        #description {
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
        }

        #infowindow-content .title {
            font-weight: bold;
        }

        #infowindow-content {
            display: none;
        }

        #map #infowindow-content {
            display: inline;
        }

        .pac-card {
            background-color: #fff;
            border: 0;
            border-radius: 2px;
            box-shadow: 0 1px 4px -1px rgba(0, 0, 0, 0.3);
            margin: 10px;
            padding: 0 0.5em;
            font: 400 18px Roboto, Arial, sans-serif;
            overflow: hidden;
            font-family: Roboto;
            padding: 0;
        }

        #pac-container {
            padding-bottom: 12px;
            margin-right: 12px;
        }

        .pac-controls {
            display: inline-block;
            padding: 5px 11px;
        }

        .pac-controls label {
            font-family: Roboto;
            font-size: 13px;
            font-weight: 300;
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 400px;
        }

        #pac-input:focus {
            border-color: #4d90fe;
        }

        #title {
            color: #fff;
            background-color: #4d90fe;
            font-size: 25px;
            font-weight: 500;
            padding: 6px 12px;
        }

        #target {
            width: 345px;
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-12 mt-2">
            <div class="page-title-box">
                <a class="btn btn-dark" href="{{ route('Dossier.show', $id) }}">Dossier</a>
            </div>
        </div>
    </div>
    <div class="row mt-2">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="page-title" style="font-size: 25px">Créer Meeting :</h4>
                        </div>
                    </div>
                    <form action="{{ route('Meeting.store') }}" method="post" id="myForm" autocomplete="off">
                        @csrf
                        <div class="row g-2">
                            <div class="col-md-4 mb-3">
                                <label for="user" class="form-label">Agent :</label>
                                <select name="user" id="user_id"
                                    class="form-select select2 @error('user') is-invalid @enderror" data-toggle="select2">
                                    @foreach ($users as $user)
                                        @if (old('user') == $user->id)
                                            <option data-user-id="{{ $user->id }}" value="{{ $user->id }}">
                                                {{ $user->name }}</option>
                                        @else
                                            <option data-user-id="{{ $user->id }}" value="{{ $user->id }}">
                                                {{ $user->name }}</option>
                                        @endif
                                    @endforeach
                                </select>
                                @error('user')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                            </div>
                            <input type="hidden" value="{{ $id }}" name="dossier_id">
                            <div class="col-md-4 mb-3">
                                <label for="garage_id" class="form-label">Garages</label>
                                <select name="garage_id" id="garage_id"
                                    class="form-select @error('garage_id') is-invalid @enderror select2"
                                    data-toggle="select2">
                                    <option value="">Selectioner Un Garage</option>
                                    @foreach ($garages as $garage)
                                        <option data-garage-id="{{ $garage->id }}" value="{{ $garage->id }}">
                                            {{ $garage->libelle }}</option>
                                    @endforeach
                                </select>
                                @error('garage_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="col-md-4 ">
                                <label for="sinister_number" class="form-label">Adresse</label>
                                <input type="text" class="form-control @error('adress') is-invalid @enderror"
                                    value="{{ old('adress') }}" id="adress" name="adress">
                                @error('adress')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                        </div>
                        <div class="row g-2">
                            <div class="col-md-4 mb-3">
                                <label for="date" class="form-label">Date :</label>
                                <input type="date" name="date" value="<?= date('Y-m-d') ?>"
                                    class="form-control @error('date')
is-invalid
@enderror">

                                @error('date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="start" class="form-label">Heure :</label>
                                <input type="time" id="start" name="start" value="{{ old('start') }}"
                                    class="form-control @error('start') is-invalid @enderror">
                                @error('start')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="row g-2 mt-2">
                                <div class="col-md-4 mb-3">
                                    <label for="date" class="form-label">Observation :</label>
                                    <textarea class="form-control @error('observation') is-invalid @enderror mb-2" name="observation" id=""
                                        cols="30" rows="5">{{ old('observation') }}</textarea>
                                    @error('observation')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label for="type" class="form-label">Type des photos</label>
                                    <select name="type" id="type"
                                        class="form-select @error('type') is-invalid @enderror ">
                                        <option value="2">PhotoAvant</option>
                                        <option value="5">PhotoEncours</option>
                                        <option value="10">PhotoApres</option>

                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label for="assure" class="form-label">Vehicule A Expertiser</label>
                                    <select name="assure" id="assure"
                                        class="form-select @error('assure') is-invalid @enderror ">
                                        <option selected value="1">Assuré</option>
                                        <option value="0">Adversaire</option>

                                    </select>
                                    @error('assure')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                            </div>

                            <div class="row g-2">

                                <div class="col-md-6">
                                    <h4 class="header-title mb-2 mt-3">Localisation :</h4>
                                    <input id="pac-input" class="controls" type="text" placeholder="Search Box" />
                                    <div id="map" class="gmaps" style="height: 60vh">
                                    </div>
                                </div>
                                <div class="col-6">
                                    <h4 class="header-title mb-2 mt-3">Meetings :</h4>
                                    <div class="card">
                                        <div class="card-body">
                                            <table id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>User</th>
                                                        <th>Ref</th>
                                                        <th>Date</th>
                                                        <th>Heure</th>
                                                        <th>Adresse</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($meetings as $meeting)
                                                        <tr>
                                                            <td class="table-user">{{ $meeting->user->name }}</td>
                                                            <td>{{ $meeting->dossier->ref }}</td>
                                                            <td>{{ $meeting->date }}</td>
                                                            <td>{{ $meeting->start }}</td>
                                                            <td>{{ $meeting->adress }}</td>

                                                            <td><span
                                                                    class="badge bg-primary">{{ $meeting->meetingstatus->status }}</span>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-6">

                                    <div class="form-group mb-2">
                                        <label for="lng">Longitude</label>
                                        <input type="text" id="lng" name="lng" value="{{ old('lng') }}"
                                            class="form-control @error('lng') is-invalid @enderror">
                                        @error('lng')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group mb-2">
                                        <label for="lat">Lattitude</label>
                                        <input type="text" id="lat" name="lat" value="{{ old('lat') }}"
                                            class="form-control @error('lat') is-invalid @enderror">
                                        @error('lat')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="row g-2">
                            <button id="btn" class="btn btn-primary"> Créer </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        document.getElementById("myForm").addEventListener("submit", function() {
            document.getElementById("btn").disabled = true;

            // You can use AJAX or other methods to handle form submission here
            // After the submission is complete, re-enable the button
            // Example using a timeout (simulated submission)
            setTimeout(function() {
                document.getElementById("btn").disabled = false;
            }, 3000); // Adjust the delay as needed
        });
        $(document).ready(function() {
            $('#user_id').on('change', function() {
                var user_id = this.value;
                $.ajax({
                    url: '/Meeting/user/' + user_id,
                    type: 'get',
                    success: function(response) {
                        // console.log(response);
                        var html = '';
                        $.each(response, function(k, v) {
                            // console.log(v);

                            html += "<tr>";
                            html += "<td>" + v.user.name + "</td>";
                            html += "<td>" + v.dossier.ref + "</td>";
                            html += "<td>" + v.date + "</td>";
                            html += "<td>" + v.start + "</td>";
                            html += "<td>" + v.adress + "</td>";
                            html += "<td > <span class='badge bg-info' >" + v
                                .meetingstatus
                                .status + "</span> </td>";
                            html += "</tr>";
                        });
                        html += '';

                        $("#myTable tbody").html(html)
                    }
                });
            });
            $('#garage_id').on('change', function() {
                var garage_id = this.value;
                $.ajax({
                    url: '/Meeting/garage/' + garage_id,
                    type: 'get',
                    success: function(response) {
                        // console.log(response[0][0]);
                        document.getElementById('adress').value = response[0][0].adress;
                        document.getElementById('lat').value = response[0][0].lat;
                        document.getElementById('lng').value = response[0][0].lng;


                        const Blocations = response[0];
                        const Clocations = response[1];

                        initMap2(Blocations, Clocations);
                    }
                });
            });

        });
    </script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&callback=initAutocomplete&libraries=places&v=weekly"
        defer></script>
    <script>
        function initAutocomplete() {
            const map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: 33.37562245379103,
                    lng: -7.579586521130635
                },
                zoom: 13,
                mapTypeId: "roadmap",
            });
            const uluru = {
                lat: 33.37562245379103,
                lng: -7.579586521130635
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });
            google.maps.event.addListener(marker, 'position_changed',
                function() {
                    let lat = marker.position.lat()
                    let lng = marker.position.lng()
                    $('#lat').val(lat)
                    $('#lng').val(lng)
                })

            google.maps.event.addListener(map, 'click',
                function(event) {
                    pos = event.latLng
                    marker.setPosition(pos)
                })
            // Create the search box and link it to the UI element.
            const input = document.getElementById("pac-input");
            const searchBox = new google.maps.places.SearchBox(input);

            map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
            // Bias the SearchBox results towards current map's viewport.
            map.addListener("bounds_changed", () => {
                searchBox.setBounds(map.getBounds());
            });

            let markers = [];

            // Listen for the event fired when the user selects a prediction and retrieve
            // more details for that place.
            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();

                if (places.length == 0) {
                    return;
                }

                // Clear out the old markers.
                markers.forEach((marker) => {
                    marker.setMap(null);
                });
                markers = [];

                // For each place, get the icon, name and location.
                const bounds = new google.maps.LatLngBounds();

                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) {
                        console.log("Returned place contains no geometry");
                        return;
                    }

                    const icon = {
                        url: place.icon,
                        size: new google.maps.Size(71, 71),
                        origin: new google.maps.Point(0, 0),
                        anchor: new google.maps.Point(17, 34),
                        scaledSize: new google.maps.Size(25, 25),
                    };


                    // Create a marker for each place.
                    markers.push(
                        new google.maps.Marker({
                            map,
                            icon,
                            title: place.name,
                            position: place.geometry.location,
                        })
                    );
                    if (place.geometry.viewport) {
                        // Only geocodes have viewport.
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }
                });
                map.fitBounds(bounds);

            });
            setMarkers(map);
            setMarkers2(map);
        }

        window.initAutocomplete = initAutocomplete;
    </script>
    {{-- <script src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&libraries=places&callback=initMap"
        async defer></script> --}}
    <script>
        // function initMap() {
        //     const map = new google.maps.Map(document.getElementById("map"), {
        //         zoom: 10,
        //         center: {
        //             lat: 33.45568426885455,
        //             lng: -7.61802005374749,
        //             zoom: 12
        //         },

        //     });
        //     const uluru = {
        //         lat: 33.45568426885455,
        //         lng: -7.61802005374749,
        //     };
        //     let marker = new google.maps.Marker({
        //         position: uluru,
        //         map: map,
        //         draggable: true
        //     });
        //     google.maps.event.addListener(marker, 'position_changed',
        //         function() {
        //             let lat = marker.position.lat()
        //             let lng = marker.position.lng()
        //             $('#lat').val(lat)
        //             $('#lng').val(lng)
        //         })

        //     google.maps.event.addListener(map, 'click',
        //         function(event) {
        //             pos = event.latLng
        //             marker.setPosition(pos)
        //         })


        //     setMarkers(map);
        //     setMarkers2(map);

        // }
        const locations = <?php print json_encode($markers); ?>;
        const image1 = "<?php print asset('img/car.png'); ?>";

        function setMarkers(map) {

            for (let i = 0; i < locations.length; i++) {
                const location = locations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'blue',
                        fontWeight: 'bold',
                        text: location.libelle,
                    },
                    icon: {
                        url: image1,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    title: location.libelle,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }
        const Alocations = <?php print json_encode($agents); ?>;
        // console.log(Alocations);
        const image =
            "https://upload.wikimedia.org/wikipedia/commons/thumb/5/59/User-avatar.svg/1200px-User-avatar.svg.png";

        function setMarkers2(map) {

            for (let i = 0; i < Alocations.length; i++) {
                const location = Alocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.user.name,

                    },
                    icon: {
                        url: image,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }

        function initMap2(Blocations, Clocations) {
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 10,
                center: {
                    lat: 33.37562245379103,
                    lng: -7.579586521130635,
                    zoom: 6
                },

            });
            const uluru = {
                lat: 33.37562245379103,
                lng: -7.579586521130635
            };
            // let marker = new google.maps.Marker({
            //     position: uluru,
            //     map: map,
            //     draggable: true
            // });
            // google.maps.event.addListener(marker, 'position_changed',
            //     function() {
            //         let lat = marker.position.lat()
            //         let lng = marker.position.lng()
            //         $('#lat').val(lat)
            //         $('#lng').val(lng)
            //     })

            // google.maps.event.addListener(map, 'click',
            //     function(event) {
            //         pos = event.latLng
            //         marker.setPosition(pos)
            //     })

            setMarkers3(map, Blocations);
            setMarkers4(map, Clocations);

        }

        function setMarkers3(map, Blocations) {

            const image2 = "https://cdn-icons-png.flaticon.com/512/75/75751.png";
            for (let i = 0; i < Blocations.length; i++) {
                const location = Blocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'red',
                        fontWeight: 'bold',
                        text: location.libelle,

                    },
                    icon: {
                        url: image2,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)
                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }

        function setMarkers4(map, Clocations) {

            for (let i = 0; i < Clocations.length; i++) {
                const location = Clocations[i];
                // console.log(location);

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.user.name,

                    },
                    icon: {
                        url: image,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }
    </script>
@endsection
