@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row mb-3">
            <form id="myForm" action="{{ route('Meeting.historique') }}" method="get">
                <div class="col-12 mt-3">
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <div class="mb-2">
                                <label class="form-label" for="company">Date Debut :</label>
                                <input class="form-control"  type="date"
                                    id="from" name="datedebut">

                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-2">
                                <label class="form-label" for="company">Date Fin :</label>
                                <input class="form-control"  type="date"
                                    id="" name="datefin">

                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="mb-2">
                                <label class="form-label" for="user">Agents :</label>
                                <select name="user" id="user" class="form-select">
                                    <option value="">Selectionner Un Agent</option>
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-2">
                                <label class="form-label" for="status">Statut :</label>
                                <select name="status_id" id="status_id" class="form-select">
                                    <option value="">Selectionner Un Statut</option>

                                    @foreach ($statuses as $status)
                                        <option value="{{ $status->id }}">{{ $status->status }}</option>
                                        @endforeach"
                                </select>
                            </div>
                        </div>
                        <div class="col-md 3">
                            <div style="margin-top: 32px" class="mb-2">
                                <div class="text-center">
                                    <button  type="submit" class="btn btn-primary"> <span class="mdi mdi-magnify search-icon">
                                    </span></button>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>

            </form>
            <div class="table-responsive">
                <table id="myTable" class="table table-centered table-nowrap mb-0" id="">
                    <thead class="table-light" >
                        <tr>

                            <th>Reference </th>
                            <th>Agent</th>
                            <th>Assuré</th>
                            <th>Date de Meet</th>
                            <th>Heure du Meet</th>
                            <th>Adresse</th>
                            <th>Expertise</th>
                            <th>Status</th>
                            <th style="width: 125px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($meetings as $meeting)
                            <tr>

                                <td>{{ $meeting->dossier->ref ?? null }} </td>
                                <td>
                                    {{ $meeting->user->name }}
                                </td>
                                <td>
                                    @if ($meeting->assure)
                                        <h5>
                                            Assuré
                                        </h5>
                                    @else
                                        <h5>
                                            Adversaire
                                        </h5>
                                    @endif
                                </td>

                                <td>
                                    <h5>
                                        {{ $meeting->date }}
                                    </h5>
                                </td>
                                <td>
                                    {{ $meeting->start }}
                                </td>
                                <td>
                                    {{ $meeting->adress ?? null }}
                                </td>
                                <td>
                                    <span class="text-primary">
                                        @if ($meeting->type == '2')
                                            Expertisen Avant
                                        @elseif ($meeting->type == '5')
                                            Expertisen En cours
                                        @elseif ($meeting->type == '10')
                                            Expertisen Aprés
                                        @endif

                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $meeting->meetingstatus->color }}">
                                        {{ $meeting->meetingstatus->status }}</span>
                                </td>
                                <td>
                                    @can('view', App\Models\Meeting::class)
                                        <a href="{{ route('Meeting.show', $meeting->id) }}" class="action-icon text-dark"> <i
                                                class="mdi mdi-eye"></i></a>
                                    @endcan
                                    @if ($meeting->meeting_status_id == 2)
                                        @can('update', App\Models\Meeting::class)
                                            <a href="{{ route('Meeting.editing', $meeting->id) }}"
                                                class="action-icon text-info">
                                                <i class="mdi mdi-pen"></i></a>
                                        @endcan
                                    @endif
                                </td>


                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-center">
                </div>
            </div>
        </div> <!-- end card-body-->
    </div> <!-- end card-->
    </div> <!-- end col -->
    </div>

    </div>

    </div>



    </div>

    </div>
@endsection
