@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form class="" action="{{ route('Settlement.store') }}" method="post">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label" for="">Company</label>
                                <select name="company_id" class="form-select @error('company_id') is-invalid @enderror" id="">
                                    @foreach ($companies as $company)
                                        <option value="{{ $company->id }}">{{ $company->company }}</option>
                                    @endforeach
                                </select>
                                @error('company_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                            </div>
                            <div class="mb-3  col-6">
                                <label class="form-label" for="">Numero De Réglement</label>
                                <input type="text" name="numero_facture"
                                    class="form-control @error('numero_facture') is-invalid @enderror">
                                @error('numero_facture')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="mb-3 col-6">
                                <label class="form-label" for="">Montant</label>
                                <input type="number" name="montant"
                                    class="form-control @error('montant') is-invalid @enderror">
                                    @error('montant')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="">Banque</label>
                                <input type="text" name="banque"
                                    class="form-control @error('banque') is-invalid @enderror">
                                @error('banque')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label " for="">Mode Paiement</label>
                                <select name="mode_paiement" class="form-select  @error('mode_paiement') is-invalid @enderror"
                                    id="">
                                    <option value="ESPECE">ESPECE</option>
                                    <option value="CHEQUE">CHEQUE</option>
                                    <option value="VIREMENT">VIREMENT</option>
                                    <option value="AUTRE">AUTRE</option>
                                </select>
                                @error('mode_paiement')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="">Date Réglement</label>
                                <input type="date" name="date_facture"
                                    class="form-control @error('date_facture') is-invalid @enderror">
                                @error('date_facture')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <button style="float: right" class="btn btn-success"> Ajouter </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
