@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <h3>{{ $user->name ?? null }}</h3>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">

                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Compagnie</th>
                                        <th>Montant Accord</th>
                                        <th>Montant Min</th>
                                        <th>Montant Max</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($user->seuil as $seuil)
                                        <tr>
                                            <td>{{ $seuil->company->company ?? null }}</td>
                                            <td>{{ $seuil->accord ?? null }}DH</td>
                                            <td>{{ $seuil->min ?? null }} DH</td>
                                            <td>{{ $seuil->max ?? null }}DH</td>

                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Seuil.edit', [$seuil->id]) }}">
                                                    <i class="uil uil-pen fs-5"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <form method="POST" action="{{ route('Seuil.destroy', $seuil->id) }}">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                        <i class="uil uil-trash fs-5"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
