@extends('layouts.config_dashboard.app')
@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Signature.store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group mb-1">
                                <label for="type">Signature</label>
                                <input type="file" name="file" value="{{ old('file') }}" required
                                    class="form-control @error('file') is-invalid @enderror">
                                @error('file')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-1">
                                <label for="type">Signature</label>
                                <select name="role" class="form-control @error('type') is-invalid @enderror"
                                    id="">
                                    @foreach ($roles as $role)
                                        <option value="{{ $role->id }}">{{ $role->role }}</option>
                                    @endforeach
                                </select>
                                @error('role')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Créer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
