@extends('layouts.dashboard.app')

@section('style')
@endsection
@section('content')
<div class="container-fluid mt-4 ">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body mt-1">
                    <form action="{{ route('Email.update',$email->id) }}" method="post">
                        @csrf
                        <div class="form-group mb-1">
                            <label for="subject">Email Sujet *:</label>
                            <textarea name="subject" required
                                class="form-control @error('subject') is-invalid @enderror "name="subject" id=""  cols="5" rows="3">
                                {{ $email->subject ?? null }}
                            </textarea>
                            @error('subject')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group mb-1">
                            <label for="content">Email Contenu :</label>
                            <textarea name="content" required
                                class="form-control @error('content') is-invalid @enderror "name="content" id="" cols="30" rows="10">
                                {{ $email->content ?? null }}
                            </textarea>
                            @error('content')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group mb-1">
                            <label for="delai">Delai *:</label>
                            <input type="number" name="delai" value="{{ $email->delai ?? null }}"  min="1"
                                class="form-control @error('delai') is-invalid @enderror">
                            @error('delai')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="type">Etapes *:</label>
                            <select name="step_id" id="step_id"
                                class="form-control @error('step_id') is-invalid @enderror">
                                <option value="{{ $email->step->id }}">{{ $email->step->step }}</option>
                                @foreach ($steps as $step)
                                    <option value="{{ $step->id }}">
                                        {{ $step->step }}</option>
                                @endforeach
                            </select>
                            @error('step_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        


                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Créer</button>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
