@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h2>
                            Historique
                        </h2>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Utilisateur</th>
                                        <th>Dossier</th>
                                        <th>Sujet</th>
                                        <th>Contenu</th>
                                        <th>Destinataire</th>
                                        <th>Documents</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($transactions as $email)
                                        <tr>
                                            <td>{{ $email->user->name ?? null }}</td>
                                            <td>{{ $email->dossier->ref ?? null }}</td>
                                            <td>{{ $email->subject ?? null }}</td>
                                            <td>{{ $email->body ?? null }}</td>
                                            <td>{{ $email->to ?? null }}</td>
                                            <td>
                                                @foreach ($email->document as $doc)
                                                <span>{{ $doc->typedocument->type  ?? null}} </span> <br>
                                                @endforeach
                                            </td>
                                            <td>{{ $email->created_at ?? null }}</td>


                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                            <div class="d-flex justify-content-center">
                                {!! $transactions->links() !!}
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
