<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/viewer.css')); ?>">
    <style>
        * {
            box-sizing: border-box;
        }

        li {
            text-decoration: none;
        }

        /* Position the image container (needed to position the left and right arrows) */
        .container {
            position: relative;
        }

        /* Hide the images by default */
        .mySlides {
            display: none;
        }

        /* Add a pointer when hovering over the thumbnail images */
        .cursor {
            cursor: pointer;
        }

        /* Next & previous buttons */
        .prev,
        .next {
            cursor: pointer;
            position: absolute;
            top: 40%;
            width: auto;
            padding: 16px;
            margin-top: -50px;
            color: white;
            font-weight: bold;
            font-size: 20px;
            border-radius: 0 3px 3px 0;
            user-select: none;
            -webkit-user-select: none;
        }

        /* Position the "next button" to the right */
        .next {
            right: 0;
            border-radius: 3px 0 0 3px;
        }

        /* On hover, add a black background color with a little bit see-through */
        .prev:hover,
        .next:hover {
            background-color: rgba(0, 0, 0, 0.8);
        }

        /* Number text (1/3 etc) */
        .numbertext {
            color: #f2f2f2;
            font-size: 12px;
            padding: 8px 12px;
            position: absolute;
            top: 0;
        }

        /* Container for image text */
        .caption-container {
            text-align: center;
            background-color: #222;
            padding: 2px 16px;
            color: white;
        }

        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        /* Six columns side by side */
        .column {
            float: left;
            width: 16.66%;
        }

        /* Add a transparency effect for thumnbail images */
        .demo {
            opacity: 0.6;
        }

        .active,
        .demo:hover {
            opacity: 1;
        }

        .container {
            position: relative;
            width: 33%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 16px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row mt-2 mb-1">
            <div class="d-flex">
                <div class="col-md-6">
                    <h4 style="float: left" class="page-title">Dossier Details <?php if($dossier->dossier_status_id === 1): ?>
                            <span class="badge bg-danger">Anomalie</span>
                        <?php endif; ?>
                    </h4>
                </div>
                <div class="col-md-6">
                    <span style="float: right" class="badge bg-warning fs-5"> <?php echo e($time->d); ?>j : <?php echo e($time->h); ?>h
                    </span>
                    <?php if($dossier->dossier_status_id != 3): ?>
                        <span style="float: right" class="badge bg-danger fs-5">
                            <?php echo e($timeleft); ?>H
                        </span>
                    <?php endif; ?>


                </div>
            </div>
        </div>
        <!-- end page title -->

        <?php echo $__env->make('dossiers.buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        


        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-dark mb-3">Réference Dossier <?php echo e($dossier->ref); ?>

                            <?php if($dossier->sinistre_douteux): ?>
                                <span class="badge bg-warning">Sinistre Douteux</span>
                            <?php endif; ?>
                        </h4>
                        <h4 class="header-title text-info mb-3">
                            <span
                                class="badge bg-<?php echo e($dossier->status->color ?? null); ?>"><?php echo e($dossier->status->status ?? null); ?></span>
                            <?php if($dossier->dossier_status_id == 3): ?>
                                <span class="badge bg-warning">Facturé</span>
                                <span class="badge bg-primary"><?php echo e($dossier->date_facturation); ?></span>
                            <?php endif; ?>
                        </h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Matricule </th>
                                        <th>Matricule WW</th>
                                        <th>Date Sinistre</th>
                                        <th>Compagnie</th>
                                        <th>Garantie</th>
                                        <th>Type de Dossier</th>
                                        <th>Mode</th>
                                        <th>Etape Courante </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <input type="hidden" value="<?php echo e($dossier->id); ?>" id="id">
                                        <td class="text-dark"><?php echo e($dossier->matricule ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->new_matricule ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->date_sinistre ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->company->company ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->guarantee->guarantee ?? null); ?></td>
                                        <td> <span
                                                class="badge badge-primary-lighten"><?php echo e($dossier->typeexpertise->type ?? null); ?></span>
                                        </td>
                                        <td> <span
                                                class="badge badge-dark-lighten"><?php echo e($dossier->mode->mode ?? null); ?></span>
                                        </td>

                                        <td>
                                            <span class="badge bg-success">
                                                <?php echo e($dossier->currentStep->step ?? null); ?>

                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->


        </div>
        <!-- end row -->
        <div class="row mt-3">
            
            <div class="col-md-6">
                
                <div class="card">
                    <div class="card-body">
                        <h3 class="header-title  text-primary mb-3">Détail :</h3>

                        <table class="table table-bordered">
                            
                            <tbody>
                                <tr>
                                    <td class="text-dark">Nom :</td>
                                    <td class="text-dark"><?php echo e($dossier->insured->civility ?? null); ?> :
                                        <?php echo e($dossier->insured->name ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Telephone :</td>
                                    <td class="text-dark"><?php echo e($dossier->insured->telephone ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Vehicule :</td>
                                    <td class="text-dark">
                                        <?php echo e($dossier->typevehicule->type ?? null); ?>/<?php echo e($dossier->vehiculemodel->name ?? null); ?>/<?php echo e($dossier->vehiculemodel->brand->brand ?? null); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Intermidiaire :</td>
                                    <td class="text-dark"><?php echo e($dossier->intermidiaire->company ?? null); ?></td>
                                </tr>
                                
                                <tr>
                                    <td class="text-dark">Numero Sinistre :</td>
                                    <td class="text-dark"><?php echo e($dossier->numero_sinistre ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Numero chassis :</td>
                                    <td class="text-dark"><?php echo e($dossier->numero_chassis ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Numero Police :</td>
                                    <td class="text-dark"><?php echo e($dossier->numero_police ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Numero Attestation :</td>
                                    <td class="text-dark"><?php echo e($dossier->numero_attestation ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">DMC :</td>
                                    <td class="text-dark"><?php echo e($dossier->date_circulation ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Ville :</td>
                                    <td class="text-dark"><?php echo e($dossier->city->city ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Devise :</td>
                                    <td class="text-dark"><?php echo e($dossier->currency->name ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Garage :</td>
                                    <td class="text-dark"><?php echo e($dossier->garage->libelle ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Kilométrage :</td>
                                    <td class="text-dark"><?php echo e($dossier->kilometrage ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Puissance Fiscale :</td>
                                    <td class="text-dark"><?php echo e($dossier->puissance_fiscale ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Carburant :</td>
                                    <td class="text-dark"><?php echo e($dossier->carburant->name ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Date Réception</td>
                                    <td class="text-dark"><?php echo e($dossier->date_reception ?? null); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-dark">Date Creation</td>
                                    <td class="text-dark"><?php echo e($dossier->created_at->format('Y-m-d') ?? null); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-dark">Montant Accord Adverse</td>
                                    <td class="text-dark"><?php echo e($dossier->montant_accord_adverse ?? 0); ?>

                                        <?php echo e($dossier->currency->symbole ?? null); ?></td>                                </tr>
                                <!-- Add more rows as needed -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- end col -->
            <?php echo $__env->make('dossiers.box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="row">

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-dark mb-3">Adversaire</h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Civilité</th>
                                        <th>Nom Complet</th>
                                        <th>Matricule</th>
                                        <th>Telephone</th>
                                        <th>Marque && Vehicule</th>
                                        <th>Compagnie</th>
                                        <th>Numero Police</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><?php echo e($dossier->opponent->civility ?? null); ?></td>
                                        <td><?php echo e($dossier->opponent->name ?? null); ?></td>
                                        <td><?php echo e($dossier->opponent->matricule ?? null); ?></td>
                                        <td><?php echo e($dossier->opponent->telephone ?? null); ?></td>
                                        <td><?php echo e($dossier->opponent->vehiculemodel->brand->brand ?? null); ?><?php echo e($dossier->opponent->vehiculemodel->name ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->opponent->company->company ?? null); ?></td>
                                        <td>
                                            <?php echo e($dossier->opponent->numero_attestation ?? null); ?>

                                        </td>
                                    </tr>
                                    </form>
                                </tbody>

                            </table>

                        </div>
                    </div>
                </div>
            </div> <!-- end col -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-dark mb-3">Valeurs :</h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Type</th>
                                        <th>Valeur A Neuf</th>
                                        <th>Hors Sinistre</th>
                                        <th>Valeur Définitive </th>
                                        <th>Valeur Epave</th>
                                        <th>Valeur Vénale</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>HT</td>
                                        <td><?php echo e($dossier->valeurneuf ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?></td>
                                        <td><?php echo e($dossier->horssinistre ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->valeuradire ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->valeurepave ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->valeurvenale ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>TTC</td>
                                        <td><?php echo e($dossier->valeurneuf_ttc ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->horssinistre_ttc ?? 0); ?>

                                            <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->valeuradire_ttc ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->valeurepave_ttc ?? 0); ?> <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                        <td><?php echo e($dossier->valeurvenale_ttc ?? 0); ?>

                                            <?php echo e($dossier->currency->symbole ?? null); ?>

                                        </td>
                                    </tr>
                                    </form>
                                </tbody>

                            </table>

                        </div>
                    </div>
                </div>
            </div>

        </div>

        

        
        <div class="row mt-3">
            <!-- end col -->
        </div>
        <?php if($montant): ?>
            <div class="row mt-2">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title mb-3 text-dark">Montant</h4>
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Montant Devis</th>
                                            <th>Montant Accord</th>
                                            <th>Montant Facture</th>
                                            <th>Montant Rapport</th>
                                            <?php if(Auth::user()->role_id == 4): ?>
                                                <th>Modifier</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?php echo e($montant->devis->montant_devis ?? 0); ?>

                                                <?php echo e($dossier->currency->symbole ?? null); ?></td>
                                            <td><?php echo e($montant->montant_accord ?? 0); ?>

                                                <?php echo e($dossier->currency->symbole ?? null); ?></td>
                                            <td><?php echo e($montant->facture->montant_facture ?? 0); ?>

                                                <?php echo e($dossier->currency->symbole ?? null); ?></td>
                                            <td><?php echo e($montant->montant_rapport ?? 0); ?>

                                                <?php echo e($dossier->currency->symbole ?? null); ?></td>

                                            <?php if(Auth::user()->role_id == 4): ?>
                                                <td>
                                                    <a href="<?php echo e(route('Montant.edit', $montant->id)); ?>"
                                                        class="action-icon text-primary">
                                                        <i class="mdi mdi-square-edit-outline"></i>
                                                    </a>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div> <!-- end col -->
                </div>
            </div>
        <?php endif; ?>
        <div class="row mt-2">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('Observation.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <h4 class="header-title mb-3" style="color: black">Observation</h4>
                            <?php if($observations): ?>
                                <div class="accordion" id="">
                                    <?php $__currentLoopData = $observations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $observation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#collapse-<?php echo e($key); ?>" aria-expanded="false"
                                                    aria-controls="">
                                                    <?php echo e($observation->user->name); ?>

                                                </button>
                                            </h2>
                                            <div id="collapse-<?php echo e($key); ?>" class="accordion-collapse collapse "
                                                aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <strong class="text-dark"><?php echo e($observation->observation); ?>.</strong>
                                                    <span><?php echo e($observation->created_at); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>

                            <div class="col-md-12 mt-1 ml-3">
                                <input type="hidden" name="dossier_id" value="<?php echo e($dossier->id); ?>">
                                <textarea name="observation" class="form-control <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> mb-2" id="observation"
                                    cols="30" rows="10"></textarea>
                                <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <button class="mt-2 btn btn-info">Créer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>


            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title mb-3" style="color: black">Point de chock</h4>
                        <?php $__empty_1 = true; $__currentLoopData = $dossier->shockpoint; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <span class="fs-5 badge  bg-warning"><?php echo e($point->point); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $dossier)): ?>
                                <a href="<?php echo e(route('ShockPoint.create', $dossier->id)); ?>" class="btn btn-danger">Créer</a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php if($historiques): ?>
            <div class="row mt-2">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title mb-3 text-dark">Historique Vehicule</h4>
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Ref</th>
                                            <th>Compagnie</th>
                                            <th>Matricule WW</th>
                                            <th>Matricule</th>
                                            <th>Assuré</th>
                                            <th>Date sinistre</th>
                                            <th>Status</th>
                                            <th>Detail</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $historiques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dossier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($dossier->ref ?? null); ?></td>
                                                <td><?php echo e($dossier->company->company ?? null); ?></td>
                                                <td><?php echo e($dossier->new_matricule ?? null); ?></td>
                                                <td><?php echo e($dossier->matricule ?? null); ?></td>
                                                <td><?php echo e($dossier->insured->name ?? null); ?></td>
                                                <td><?php echo e($dossier->date_sinistre ?? null); ?></td>

                                                <td>
                                                    <span class="badge bg-<?php echo e($dossier->status->color ?? null); ?>">
                                                        <?php echo e($dossier->status->status ?? null); ?></span>
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('Dossier.show', $dossier->id)); ?>">
                                                        <i class="mdi mdi-eye"></i></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    </div>

    </div>
    <?php echo $__env->make('document.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admin/public_html/engi.ameamaroc.ma/resources/views/dossiers/show.blade.php ENDPATH**/ ?>